import { h, Host } from '@stencil/core';
import { HtmlUtil } from '../../services/utils/html-util';
export class OntotextDialogWebComponent {
  constructor() {
    this.config = undefined;
  }
  /**
   * Handles the Escape key keydown event and closes the dialog.
   * @param ev The keyboard event.
   */
  keydownListener(ev) {
    if (ev.key === 'Escape') {
      this.closeButton.click();
    }
  }
  componentDidLoad() {
    this.documentOverflow = HtmlUtil.hideDocumentBodyOverflow();
    this.hostElement.addEventListener('keydown', this.preventLeavingDialog.bind(this));
    this.closeButton.focus();
  }
  disconnectedCallback() {
    this.hostElement.removeEventListener('keydown', this.preventLeavingDialog.bind(this));
    HtmlUtil.setDocumentBodyOverflow(this.documentOverflow);
  }
  preventLeavingDialog(ev) {
    HtmlUtil.preventLeavingDialog(this.hostElement, ev);
  }
  render() {
    return (h(Host, { tabindex: '-1' }, h("div", { class: "dialog-overlay", onClick: (evt) => this.config.onClose(evt) }, h("div", { class: "dialog" }, h("div", { class: "dialog-header" }, h("h3", { class: "dialog-title" }, this.config.dialogTitle), h("button", { class: "close-button icon-close", onClick: (evt) => this.config.onClose(evt), ref: (el) => (this.closeButton = el) })), h("div", { class: "dialog-body" }, h("slot", { name: "body" })), h("div", { class: "dialog-footer" }, h("slot", { name: "footer" }))))));
  }
  static get is() { return "ontotext-dialog-web-component"; }
  static get originalStyleUrls() {
    return {
      "$": ["ontotext-dialog-web-component.scss"]
    };
  }
  static get styleUrls() {
    return {
      "$": ["ontotext-dialog-web-component.css"]
    };
  }
  static get properties() {
    return {
      "config": {
        "type": "unknown",
        "mutable": false,
        "complexType": {
          "original": "DialogConfig",
          "resolved": "{ dialogTitle: string; onClose: (evt: KeyboardEvent | MouseEvent) => void; }",
          "references": {
            "DialogConfig": {
              "location": "local"
            }
          }
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": ""
        }
      }
    };
  }
  static get elementRef() { return "hostElement"; }
  static get listeners() {
    return [{
        "name": "keydown",
        "method": "keydownListener",
        "target": "document",
        "capture": false,
        "passive": false
      }];
  }
}
