import { h, Host } from '@stencil/core';
import tippy from 'tippy.js';
export class OntotextTooltipWebComponent {
  constructor() {
    this.dataTooltip = undefined;
    this.placement = undefined;
    this.showOnClick = undefined;
  }
  configurationChanged() {
    this.update();
  }
  componentDidLoad() {
    this.init();
  }
  disconnectedCallback() {
    this.destroy();
  }
  render() {
    return (h(Host, { class: "yasgui-tooltip" }, h("slot", null)));
  }
  update() {
    this.init();
    this.tooltip.setContent(this.dataTooltip);
  }
  init() {
    if (this.tooltip) {
      return;
    }
    const options = {
      content: this.dataTooltip,
      trigger: 'manual',
      placement: this.placement,
      allowHTML: true,
      triggerTarget: this.el,
      /**
       * The tippy library has some conflict with the Google Chart Editor. The editor adds a div element with the "jfk-tooltip" class.
       * When the mouse hovers over a chart editor element, this div is positioned accordingly.
       * When the mouse leaves the element, a "jfk-tooltip-hidden" class is added, and the div tag is hidden.
       * For some reason, when a 'ontotext-tooltip-web-component' is open, the "jfk-tooltip-hidden" class is removed, and the Google Chart tooltip is displayed along with
       * 'ontotext-tooltip-web-component' (maybe Google uses an old version of tippy or popover and there is a conflict in implementations).
       * When 'ontotext-tooltip-web-component' is open, we add the class 'hidden' to the Google Chart tooltip to hide it.
       */
      onShow: () => document.querySelectorAll('.jfk-tooltip').forEach(popper => popper.classList.add('hidden')),
      /**
       * When 'ontotext-tooltip-web-component' is closed, we remove the 'hidden' class to allow the Google Chart tooltip to work properly.
       */
      onHide: () => document.querySelectorAll('.jfk-tooltip').forEach(popper => popper.classList.remove('hidden'))
    };
    this.tooltip = tippy(this.el, options);
    this.showFunction = this.createShowFunction(this.tooltip);
    this.hideFunction = this.createHideFunction(this.tooltip);
    this.el.addEventListener('mouseover', this.showFunction);
    if (this.showOnClick) {
      this.el.addEventListener('click', this.showFunction);
    }
    this.el.addEventListener('mouseleave', this.hideFunction);
  }
  createShowFunction(tooltip) {
    return () => {
      if (this.dataTooltip) {
        tooltip.show();
      }
    };
  }
  createHideFunction(tooltip) {
    return () => tooltip.hide();
  }
  destroy() {
    this.el.removeEventListener('mouseover', this.showFunction);
    this.el.removeEventListener('click', this.showFunction);
    this.el.removeEventListener('mouseleave', this.hideFunction);
  }
  static get is() { return "yasgui-tooltip"; }
  static get originalStyleUrls() {
    return {
      "$": ["ontotext-tooltip-web-component.scss"]
    };
  }
  static get styleUrls() {
    return {
      "$": ["ontotext-tooltip-web-component.css"]
    };
  }
  static get properties() {
    return {
      "dataTooltip": {
        "type": "string",
        "mutable": false,
        "complexType": {
          "original": "string",
          "resolved": "string",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": ""
        },
        "attribute": "data-tooltip",
        "reflect": false
      },
      "placement": {
        "type": "string",
        "mutable": false,
        "complexType": {
          "original": "string",
          "resolved": "string",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": ""
        },
        "attribute": "placement",
        "reflect": false
      },
      "showOnClick": {
        "type": "boolean",
        "mutable": false,
        "complexType": {
          "original": "false",
          "resolved": "boolean",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": ""
        },
        "attribute": "show-on-click",
        "reflect": false
      }
    };
  }
  static get elementRef() { return "el"; }
  static get watchers() {
    return [{
        "propName": "dataTooltip",
        "methodName": "configurationChanged"
      }];
  }
}
