import { Host, h } from '@stencil/core';
import { Page } from '../../models/page';
export class Pagination {
  constructor() {
    this.VISIBLE_PAGES_COUNT = 5;
    this.PAGES_COUNT_AROUND_CURRENT = 2;
    this.pageNumber = 1;
    this.pageSize = 10;
    this.totalElements = 0;
    this.pageElements = undefined;
    this.hasMorePages = undefined;
    this.selectPage(this.pageNumber);
  }
  getShownPageNumbers() {
    const lastShownPage = this.fetchLastShownPage();
    const firstShownPage = this.fetchFirstShownPage(lastShownPage);
    const pages = [];
    for (let index = firstShownPage; index <= lastShownPage; index++) {
      pages.push(index);
    }
    return pages;
  }
  fetchLastShownPage() {
    const currentPageNumber = this.pageNumber;
    let lastShownPage = currentPageNumber;
    const pagesAfterCurrent = currentPageNumber <= 3 ? this.VISIBLE_PAGES_COUNT - currentPageNumber : this.PAGES_COUNT_AROUND_CURRENT;
    for (let pageNumber = 0; pageNumber < pagesAfterCurrent; pageNumber++) {
      if ((currentPageNumber + pageNumber) * this.pageSize < this.totalElements) {
        lastShownPage += 1;
      }
    }
    return lastShownPage;
  }
  fetchFirstShownPage(lastShownPage) {
    const firstPage = lastShownPage - this.VISIBLE_PAGES_COUNT + 1;
    return firstPage < 1 ? 1 : firstPage;
  }
  previousButtonDisabled() {
    return this.pageNumber < this.PAGES_COUNT_AROUND_CURRENT;
  }
  nextButtonDisabled() {
    if (this.totalElements && this.totalElements >= 0) {
      return this.pageNumber * this.pageSize >= this.totalElements;
    }
    return !this.hasMorePages;
  }
  nextPage() {
    this.pageSelected.emit(new Page(this.pageSize, this.pageNumber + 1));
  }
  previousPage() {
    this.pageSelected.emit(new Page(this.pageSize, this.pageNumber - 1));
  }
  selectPage(pageNumber) {
    if (this.pageNumber !== pageNumber) {
      this.pageSelected.emit(new Page(this.pageSize, pageNumber));
    }
  }
  render() {
    return (h(Host, { class: "ontotext-pagination" }, h("div", { class: "page-selectors" }, h("button", { class: "page-selector previous-button", onClick: () => this.previousPage(), disabled: this.previousButtonDisabled() }, "\u2039"), this.getShownPageNumbers().map(pageNumber => {
      return h("button", { class: `page-button page-selector ${this.pageNumber === pageNumber ? 'selected-page' : ''}`, onClick: () => this.selectPage(pageNumber), disabled: this.pageNumber === pageNumber }, pageNumber);
    }), h("button", { class: "page-selector next-button", onClick: () => this.nextPage(), disabled: this.nextButtonDisabled() }, "\u203A"))));
  }
  static get is() { return "ontotext-pagination"; }
  static get originalStyleUrls() {
    return {
      "$": ["pagination.scss"]
    };
  }
  static get styleUrls() {
    return {
      "$": ["pagination.css"]
    };
  }
  static get properties() {
    return {
      "pageNumber": {
        "type": "number",
        "mutable": false,
        "complexType": {
          "original": "number",
          "resolved": "number",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": ""
        },
        "attribute": "page-number",
        "reflect": false,
        "defaultValue": "1"
      },
      "pageSize": {
        "type": "number",
        "mutable": false,
        "complexType": {
          "original": "number",
          "resolved": "number",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": ""
        },
        "attribute": "page-size",
        "reflect": false,
        "defaultValue": "10"
      },
      "totalElements": {
        "type": "number",
        "mutable": false,
        "complexType": {
          "original": "number",
          "resolved": "number",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": ""
        },
        "attribute": "total-elements",
        "reflect": false,
        "defaultValue": "0"
      },
      "pageElements": {
        "type": "number",
        "mutable": false,
        "complexType": {
          "original": "number",
          "resolved": "number",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": ""
        },
        "attribute": "page-elements",
        "reflect": false
      },
      "hasMorePages": {
        "type": "boolean",
        "mutable": false,
        "complexType": {
          "original": "boolean | undefined",
          "resolved": "boolean",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": ""
        },
        "attribute": "has-more-pages",
        "reflect": false
      }
    };
  }
  static get events() {
    return [{
        "method": "pageSelected",
        "name": "pageSelected",
        "bubbles": true,
        "cancelable": true,
        "composed": true,
        "docs": {
          "tags": [],
          "text": ""
        },
        "complexType": {
          "original": "Page",
          "resolved": "Page",
          "references": {
            "Page": {
              "location": "import",
              "path": "../../models/page"
            }
          }
        }
      }];
  }
}
