import { h, Host } from '@stencil/core';
import { DeleteQueryData, UpdateQueryData } from "../../models/saved-query-configuration";
import { TranslationService } from "../../services/translation.service";
export class SavedQueriesPopup {
  constructor() {
    this.config = undefined;
    this.serviceFactory = undefined;
  }
  onWindowResize(event) {
    const target = event.target;
    if (!target.closest('.saved-queries-container')) {
      this.internalCloseSavedQueriesPopupEvent.emit();
    }
  }
  /**
   * Handles the Escape key keydown event and closes the dialog.
   * @param ev The keyboard event.
   */
  keydownListener(ev) {
    if (ev.key === 'Escape') {
      this.internalCloseSavedQueriesPopupEvent.emit();
    }
  }
  onSelect(evt, selectedQuery) {
    evt.stopPropagation();
    this.internalSaveQuerySelectedEvent.emit(selectedQuery);
  }
  componentWillLoad() {
    // TranslationService is injected here because the service factory is not available
    // in the constructor.
    this.translationService = this.serviceFactory.get(TranslationService);
  }
  componentDidRender() {
    this.setPopupPosition();
  }
  onEdit(evt, selectedQuery) {
    evt.stopPropagation();
    this.internalEditSavedQueryEvent.emit(new UpdateQueryData(selectedQuery.queryName, selectedQuery.query, selectedQuery.isPublic, false));
  }
  onDelete(evt, selectedQuery) {
    evt.stopPropagation();
    this.internalSavedQuerySelectedForDeleteEvent.emit(new DeleteQueryData(selectedQuery.queryName, selectedQuery.query, selectedQuery.isPublic));
  }
  onShare(evt, selectedQuery) {
    evt.stopPropagation();
    this.internalSavedQuerySelectedForShareEvent.emit(new DeleteQueryData(selectedQuery.queryName, selectedQuery.query, selectedQuery.isPublic));
  }
  setPopupPosition() {
    const panelRect = this.hostElement.getBoundingClientRect();
    const buttonRect = this.config.popupTarget.getBoundingClientRect();
    const isFullScreen = this.hostElement.closest('ontotext-yasgui').querySelector('.yasqe').classList.contains('yasqe-fullscreen');
    const arrowEl = this.hostElement.querySelector('.arrow');
    if (isFullScreen) {
      this.hostElement.style.top = '13px';
      this.hostElement.style.left = (buttonRect.left - panelRect.width - 10) + 'px';
      arrowEl.style.top = '40px';
    }
    else {
      this.hostElement.style.top = ((buttonRect.top + buttonRect.height / 2) - panelRect.height / 2) + 'px';
      this.hostElement.style.left = (buttonRect.left - panelRect.width - 10) + 'px';
      arrowEl.style.top = panelRect.height / 2 - 16 + 'px';
    }
  }
  render() {
    return (h(Host, { class: "saved-queries-container" }, h("div", { class: "arrow" }), h("div", { class: "saved-queries-popup" }, h("ul", null, this.config.savedQueriesList.map((savedQuery) => (h("li", { class: "saved-query" }, h("a", { class: "saved-query-link", onClick: (evt) => this.onSelect(evt, savedQuery) }, savedQuery.queryName), h("span", { class: "saved-query-actions" }, h("button", { class: "saved-query-action edit-saved-query icon-edit", title: this.translationService.translate('yasqe.actions.saved_query_dialog.edit.button.tooltip'), onClick: (evt) => this.onEdit(evt, savedQuery) }), h("button", { class: "saved-query-action delete-saved-query icon-trash", title: this.translationService.translate('yasqe.actions.saved_query_dialog.delete.button.tooltip'), onClick: (evt) => this.onDelete(evt, savedQuery) }), h("button", { class: "saved-query-action share-saved-query icon-link", title: this.translationService.translate('yasqe.actions.saved_query_dialog.share.button.tooltip'), onClick: (evt) => this.onShare(evt, savedQuery) })))))))));
  }
  static get is() { return "saved-queries-popup"; }
  static get originalStyleUrls() {
    return {
      "$": ["saved-queries-popup.scss"]
    };
  }
  static get styleUrls() {
    return {
      "$": ["saved-queries-popup.css"]
    };
  }
  static get properties() {
    return {
      "config": {
        "type": "unknown",
        "mutable": false,
        "complexType": {
          "original": "SavedQueriesData",
          "resolved": "SavedQueriesData",
          "references": {
            "SavedQueriesData": {
              "location": "import",
              "path": "../../models/saved-query-configuration"
            }
          }
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": ""
        }
      },
      "serviceFactory": {
        "type": "unknown",
        "mutable": false,
        "complexType": {
          "original": "ServiceFactory",
          "resolved": "ServiceFactory",
          "references": {
            "ServiceFactory": {
              "location": "import",
              "path": "../../services/service-factory"
            }
          }
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": ""
        }
      }
    };
  }
  static get events() {
    return [{
        "method": "internalSaveQuerySelectedEvent",
        "name": "internalSaveQuerySelectedEvent",
        "bubbles": true,
        "cancelable": true,
        "composed": true,
        "docs": {
          "tags": [],
          "text": "Event fired when a saved query is selected from the list."
        },
        "complexType": {
          "original": "SaveQueryData",
          "resolved": "SaveQueryData",
          "references": {
            "SaveQueryData": {
              "location": "import",
              "path": "../../models/saved-query-configuration"
            }
          }
        }
      }, {
        "method": "internalEditSavedQueryEvent",
        "name": "internalEditSavedQueryEvent",
        "bubbles": true,
        "cancelable": true,
        "composed": true,
        "docs": {
          "tags": [],
          "text": "Event fired when the edit saved query button is triggered."
        },
        "complexType": {
          "original": "SaveQueryData",
          "resolved": "SaveQueryData",
          "references": {
            "SaveQueryData": {
              "location": "import",
              "path": "../../models/saved-query-configuration"
            }
          }
        }
      }, {
        "method": "internalSavedQuerySelectedForDeleteEvent",
        "name": "internalSavedQuerySelectedForDeleteEvent",
        "bubbles": true,
        "cancelable": true,
        "composed": true,
        "docs": {
          "tags": [],
          "text": "Event fired when the delete saved query button is triggered."
        },
        "complexType": {
          "original": "SaveQueryData",
          "resolved": "SaveQueryData",
          "references": {
            "SaveQueryData": {
              "location": "import",
              "path": "../../models/saved-query-configuration"
            }
          }
        }
      }, {
        "method": "internalSavedQuerySelectedForShareEvent",
        "name": "internalSavedQuerySelectedForShareEvent",
        "bubbles": true,
        "cancelable": true,
        "composed": true,
        "docs": {
          "tags": [],
          "text": "Event fired when the share saved query button is triggered."
        },
        "complexType": {
          "original": "SaveQueryData",
          "resolved": "SaveQueryData",
          "references": {
            "SaveQueryData": {
              "location": "import",
              "path": "../../models/saved-query-configuration"
            }
          }
        }
      }, {
        "method": "internalCloseSavedQueriesPopupEvent",
        "name": "internalCloseSavedQueriesPopupEvent",
        "bubbles": true,
        "cancelable": true,
        "composed": true,
        "docs": {
          "tags": [],
          "text": "Event fired when the saved queries popup should be closed."
        },
        "complexType": {
          "original": "any",
          "resolved": "any",
          "references": {}
        }
      }];
  }
  static get elementRef() { return "hostElement"; }
  static get listeners() {
    return [{
        "name": "click",
        "method": "onWindowResize",
        "target": "window",
        "capture": false,
        "passive": false
      }, {
        "name": "keydown",
        "method": "keydownListener",
        "target": "window",
        "capture": false,
        "passive": false
      }];
  }
}
