import { h } from '@stencil/core';
export class ShareQueryDialog {
  constructor() {
    this.config = undefined;
    this.serviceFactory = undefined;
  }
  onDialogClosed() {
    this.internalShareQueryDialogClosedEvent.emit();
  }
  onLinkCopied() {
    this.internalQueryShareLinkCopiedEvent.emit();
  }
  render() {
    return (h("copy-link-dialog", { config: { copyLink: this.config.shareQueryLink }, serviceFactory: this.serviceFactory, classes: "share-saved-query-dialog", copyLinkEventsObserver: this }));
  }
  static get is() { return "share-query-dialog"; }
  static get originalStyleUrls() {
    return {
      "$": ["share-query-dialog.scss"]
    };
  }
  static get styleUrls() {
    return {
      "$": ["share-query-dialog.css"]
    };
  }
  static get properties() {
    return {
      "config": {
        "type": "unknown",
        "mutable": false,
        "complexType": {
          "original": "ShareQueryDialogConfig",
          "resolved": "{ shareQueryLink: string; }",
          "references": {
            "ShareQueryDialogConfig": {
              "location": "local"
            }
          }
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": ""
        }
      },
      "serviceFactory": {
        "type": "unknown",
        "mutable": false,
        "complexType": {
          "original": "ServiceFactory",
          "resolved": "ServiceFactory",
          "references": {
            "ServiceFactory": {
              "location": "import",
              "path": "../../services/service-factory"
            }
          }
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": ""
        }
      }
    };
  }
  static get events() {
    return [{
        "method": "internalShareQueryDialogClosedEvent",
        "name": "internalShareQueryDialogClosedEvent",
        "bubbles": true,
        "cancelable": true,
        "composed": true,
        "docs": {
          "tags": [],
          "text": "Event fired when the dialog is closed by triggering one of the close controls, e.g. close or\ncancel button as well as clicking outside of the dialog."
        },
        "complexType": {
          "original": "any",
          "resolved": "any",
          "references": {}
        }
      }, {
        "method": "internalQueryShareLinkCopiedEvent",
        "name": "internalQueryShareLinkCopiedEvent",
        "bubbles": true,
        "cancelable": true,
        "composed": true,
        "docs": {
          "tags": [],
          "text": "Internal event fired when saved query share link is copied in the clipboard."
        },
        "complexType": {
          "original": "any",
          "resolved": "any",
          "references": {}
        }
      }];
  }
}
