import { InternalEventType } from './internal-event-types';
import { OutputEventType } from '../output-events/output-event-types';
export const MessageType = {
  SUCCESS: 'success',
  ERROR: 'error',
  WARNING: 'warning',
  INFO: 'info',
};
export const MessageCode = {
  RESOURCE_LINK_COPIED_SUCCESSFULLY: 'resource_link_copied_successfully',
  QUERY_IS_RUNNING: 'query_is_running',
  EXPLAIN_NOT_ALLOWED: 'explain_not_allowed',
  EXPLAIN_EXIT_FULLSCREEN: 'explain_exit_fullscreen'
};
export class InternalNotificationMessageEvent {
  constructor(code, messageType, message) {
    this.TYPE = InternalEventType.INTERNAL_NOTIFICATION_MESSAGE_EVENT;
    this.OUTPUT_TYPE = OutputEventType.OUTPUT_NOTIFICATION_MESSAGE_EVENT;
    this.payload = { code, messageType, message };
  }
}
