export class OutputEvent {
  constructor(TYPE, payload) {
    this.TYPE = TYPE;
    this.payload = payload;
  }
}
export const toOutputEvent = (internalEvent) => {
  if (!internalEvent.detail.OUTPUT_TYPE) {
    throw Error(`Can't convert ${internalEvent.detail.TYPE} to OutputEvent. Missing property "OUTPUT_TYPE"`);
  }
  return new OutputEvent(internalEvent.detail.OUTPUT_TYPE, removeUndefinedProperties(internalEvent.detail.payload));
};
export const removeUndefinedProperties = (object) => {
  if (!object) {
    return {};
  }
  return Object.keys(object).reduce((resultObject, key) => {
    const _resultObject = resultObject;
    if (object[key] !== undefined) {
      _resultObject[key] = object[key];
    }
    return _resultObject;
  }, {});
};
