import { PivotTableRendererType } from './pivot-table-renderer-type';
const RENDERER_ORDER_LIST = [
  PivotTableRendererType.TABLE,
  PivotTableRendererType.TABLE_BARCHART,
  PivotTableRendererType.HEATMAP,
  PivotTableRendererType.ROW_HEATMAP,
  PivotTableRendererType.COL_HEATMAP,
  PivotTableRendererType.TREEMAP,
  PivotTableRendererType.LINE_CHART,
  PivotTableRendererType.BAR_CHART,
  PivotTableRendererType.STACKED_BAR_CHART,
  PivotTableRendererType.AREA_CHART,
  PivotTableRendererType.SCATTER_CHART,
  PivotTableRendererType.TSV_EXPORT
];
export class PivotTableRenderer {
  constructor(name, type) {
    this.name = name;
    this.type = type;
    this.order = RENDERER_ORDER_LIST.indexOf(this.type);
  }
}
