export var RenderingMode;
(function (RenderingMode) {
  RenderingMode["YASGUI"] = "mode-yasgui";
  RenderingMode["YASQE"] = "mode-yasqe";
  RenderingMode["YASR"] = "mode-yasr";
})(RenderingMode || (RenderingMode = {}));
export var Orientation;
(function (Orientation) {
  Orientation["VERTICAL"] = "orientation-vertical";
  Orientation["HORIZONTAL"] = "orientation-horizontal";
})(Orientation || (Orientation = {}));
export const defaultOntotextYasguiConfig = {
  render: RenderingMode.YASGUI,
  orientation: Orientation.VERTICAL,
  showEditorTabs: true,
  showResultTabs: true,
  showResultInfo: true,
  showToolbar: false,
  showControlBar: false
};
export const defaultYasguiConfig = {
  copyEndpointOnNewTab: true,
  populateFromUrl: false,
  persistenceLabelConfig: "ontotext-yasgui-config",
  endpoint: '',
  method: 'POST',
  infer: true,
  immutableInfer: false,
  sameAs: true,
  immutableSameAs: false,
  pageSize: 10,
  paginationOn: true,
  keyboardShortcutConfiguration: {
    execute_explain_plan_for_query: false,
    execute_chat_gpt_explain_plan_for_query: false
  },
  getRepositoryStatementsCount: () => Promise.resolve(),
  beforeUpdateQuery: () => Promise.resolve({}),
  headers: () => {
    return {
      'Content-Type': 'application/x-www-form-urlencoded',
      'Accept': 'application/sparql-results+json',
      'X-GraphDB-Local-Consistency': 'updating'
    };
  }
};
export const defaultYasqeConfig = {
  query: 'select * where {\n    ?s ?p ?o .\n} limit 100',
  initialQuery: '',
  createShareableLink: null,
  yasqeActionButtons: [
    { name: 'createSavedQuery', visible: true },
    { name: 'showSavedQueries', visible: true },
    { name: 'shareQuery', visible: true },
    { name: 'includeInferredStatements', visible: true }
  ],
  prefixes: {},
  isVirtualRepository: false,
  showQueryButton: true,
  resizeable: true,
  readOnly: false
};
export const defaultYasrConfig = {
  defaultPlugin: 'extended_table',
  pluginOrder: ['extended_table', 'extended_response', 'pivot-table-plugin', 'charts'],
  showQueryLoader: true,
};
