export class PivotTableDownloadUtil {
  // @ts-ignore
  static getTSVDownloadInfo(yasr) {
    return {
      contentType: "text/tsv",
      filename: "queryResults.tsv",
      getData: () => yasr.rootEl.querySelector('.pvtRendererArea textarea').innerHTML
    };
  }
  // @ts-ignore
  static getCSVDownloadInfo(yasr) {
    return {
      contentType: "text/csv",
      filename: "queryResults.csv",
      getData: () => PivotTableDownloadUtil.tableToCsv(yasr.rootEl.querySelector('.pvtRendererArea table'))
    };
  }
  // @ts-ignore
  static getSvgDownloadInfo(yasr) {
    return {
      contentType: "image/svg+xml",
      filename: "queryResults.svg",
      getData: () => yasr.rootEl.querySelector('.pvtRendererArea svg').outerHTML
    };
  }
  static tableToCsv(tableElement, config = undefined) {
    let csvString = "";
    const configuration = Object.assign(new TableToCsvConfiguration(), config);
    csvString += PivotTableDownloadUtil.getTableHeaderAsCSV(tableElement, configuration);
    csvString += PivotTableDownloadUtil.getTableBodyAsCSV(tableElement, configuration);
    return csvString;
  }
  static getTableHeaderAsCSV(tableElement, config) {
    const headerRows = tableElement.querySelectorAll('thead tr');
    if (!headerRows || headerRows.length < 1) {
      return '';
    }
    return this.toCSVFormat(PivotTableDownloadUtil.getThValuesMatrix(headerRows, config), config);
  }
  static getTableBodyAsCSV(element, config) {
    let csvString = '';
    const querySelector = element.querySelector('tbody');
    if (!querySelector) {
      return;
    }
    const bodyRows = querySelector.querySelectorAll('tr');
    if (!bodyRows || bodyRows.length < 1) {
      return '';
    }
    const thValueMatrix = PivotTableDownloadUtil.getThValuesMatrix(bodyRows, config);
    bodyRows.forEach((row, rowIndex) => {
      csvString += thValueMatrix[rowIndex].join(config.delimiter);
      const tdData = [];
      row.querySelectorAll('td').forEach((cell) => {
        tdData.push(PivotTableDownloadUtil.escapeValueIfNeeded(cell.innerText, config));
      });
      if (tdData.length > 0) {
        csvString += config.delimiter + tdData.join(config.delimiter) + config.lineBreak;
      }
    });
    return csvString;
  }
  static getColspan(element) {
    const colspanAttribute = element.getAttribute('colspan');
    return colspanAttribute ? parseInt(colspanAttribute, 10) : 1;
  }
  static getRowspan(element) {
    const rowspan = element.getAttribute('rowspan');
    return rowspan ? parseInt(rowspan, 10) : 1;
  }
  static findIndexOfFirstUndefinedElement(array) {
    return array.findIndex((element) => element === undefined);
  }
  static getThValuesMatrix(rowElements, config) {
    const thValuesMatrix = Array.from(Array(rowElements.length), () => new Array(PivotTableDownloadUtil.getColumnsCount(rowElements)));
    let currentColumnPosition = 0;
    rowElements.forEach((row, rowIndex) => {
      currentColumnPosition = 0;
      row.querySelectorAll('th').forEach((cellElement) => {
        const cellValue = PivotTableDownloadUtil.escapeValueIfNeeded(cellElement.innerText || "", config);
        const colspanValue = PivotTableDownloadUtil.getColspan(cellElement);
        const rowspanValue = PivotTableDownloadUtil.getRowspan(cellElement);
        for (let colIndex = 0; colIndex < colspanValue; colIndex++) {
          const matrixCellValue = thValuesMatrix[rowIndex][currentColumnPosition];
          if (matrixCellValue === undefined) {
            thValuesMatrix[rowIndex][currentColumnPosition] = cellValue;
          }
          else {
            // The matrix value is populated because some previous element had a rowspan greater than 1.
            // So the cell value have to be populated on next not filled element.
            thValuesMatrix[rowIndex][PivotTableDownloadUtil.findIndexOfFirstUndefinedElement(thValuesMatrix[rowIndex])] = cellValue;
            currentColumnPosition++;
          }
          // If the rowspan value is greater than 1, we will copy the cell value to the next rows and same column into the value matrix.
          for (let index = 1; index < rowspanValue; index++) {
            thValuesMatrix[rowIndex + index][currentColumnPosition] = cellValue;
          }
          currentColumnPosition++;
        }
      });
    });
    return thValuesMatrix;
  }
  static needToQuoteString(value, config) {
    //quote when it contains whitespace, quote or the delimiter
    return !!value.match("[\\w|" + config.delimiter + "|" + config.quote + "]");
  }
  static escapeValueIfNeeded(value, config) {
    if (PivotTableDownloadUtil.needToQuoteString(value, config)) {
      return `"${value}"`;
    }
    return value;
  }
  static toCSVFormat(data, config) {
    let csv = '';
    for (let rowIndex = 0; rowIndex < data.length; rowIndex++) {
      csv += data[rowIndex].join(config.delimiter) + config.lineBreak;
    }
    return csv;
  }
  static getColumnsCount(thElements) {
    let allColumns = 0;
    thElements[0].querySelectorAll('th').forEach((thElement) => {
      const colspan = thElement.getAttribute('colspan');
      if (colspan) {
        allColumns += parseInt(colspan, 10);
      }
      else {
        allColumns++;
      }
    });
    return allColumns;
  }
}
export class TableToCsvConfiguration {
  constructor() {
    this.quote = "\"";
    this.delimiter = ",";
    this.lineBreak = "\n";
  }
}
