export class NamespaceService {
  static namespacesMapToArray(namespaceMapping) {
    if (!namespaceMapping) {
      return [];
    }
    let hasOntoPrefix = false;
    const namespaces = Object.keys(namespaceMapping).map((prefix) => {
      if (prefix === 'onto') {
        hasOntoPrefix = true;
      }
      return `${prefix}: <${namespaceMapping[prefix]}>`;
    });
    if (!hasOntoPrefix) {
      namespaces.push('onto: <http://www.ontotext.com/>');
    }
    namespaces.sort();
    return namespaces;
  }
}
