import { InternalNotificationMessageEvent, MessageType, } from '../models/internal-events/internal-notification-message-event';
export class NotificationMessageService {
  constructor(serviceFactory) {
    this.eventService = serviceFactory.getEventService();
  }
  info(code, message) {
    this.notify(code, MessageType.INFO, message);
  }
  success(code, message) {
    this.notify(code, MessageType.SUCCESS, message);
  }
  warning(code, message) {
    this.notify(code, MessageType.WARNING, message);
  }
  error(code, message) {
    this.notify(code, MessageType.ERROR, message);
  }
  notify(code, messageType, message) {
    this.eventService.emit(new InternalNotificationMessageEvent(code, messageType, message));
  }
}
