export class TooltipService {
  /**
   * Wrap <code>element</code> with {@see OntotextTooltipWebComponent} and sets tooltip attributes <code>tooltip</code>, <code>placement</code> and <code>showOnclick</code>.
   * If element has a parent it will be detached of it and created tooltip wrapper element will be attached to the element parent.
   * @param element - the element that will be wrapped with {@see OntotextTooltipWebComponent}.
   * @param tooltip - the tooltip.
   * @param placement - placement of tooltip.
   * @param showOnclick - if tooltip have to be shown on click event.
   */
  static addTooltip(element, tooltip, placement, showOnclick = true) {
    const tooltipElement = document.createElement('yasgui-tooltip');
    const parentElement = element.parentElement;
    if (parentElement) {
      parentElement.replaceChild(tooltipElement, element);
    }
    tooltipElement.appendChild(element);
    TooltipService.updateTooltipData(tooltipElement, tooltip);
    TooltipService.updatePlacement(tooltipElement, placement);
    tooltipElement.setAttribute("show-on-click", `${showOnclick}`);
    return tooltipElement;
  }
  static updateTooltip(element, tooltip, placement) {
    const parentElement = element === null || element === void 0 ? void 0 : element.parentElement;
    if (parentElement && 'yasgui-tooltip' === parentElement.tagName.toLowerCase()) {
      TooltipService.updateTooltipData(parentElement, tooltip);
      TooltipService.updatePlacement(parentElement, placement);
    }
  }
  static updateTooltipData(element, tooltip) {
    if (tooltip) {
      element.setAttribute('data-tooltip', tooltip);
      element.setAttribute("aria-label", tooltip);
    }
  }
  static updatePlacement(element, placement) {
    if (placement) {
      element.setAttribute('placement', placement);
    }
  }
}
