export class HtmlElementsUtil {
  /**
   * Fetches the yasgui html element.
   * @param hostElement - the host element of "ontotext-yasgui-web-component".
   */
  static getOntotextYasgui(hostElement) {
    return hostElement.querySelector('.ontotext-yasgui');
  }
  static getRenderModeButton(hostElement, mode) {
    return hostElement.querySelector(`.btn-${mode}`);
  }
  /**
   * Fetches the orientation button.
   * @param hostElement - the host element of "ontotext-yasgui-web-component".
   */
  static getOrientationButton(hostElement) {
    return hostElement.querySelector('.btn-orientation');
  }
  /**
   * Fetches the toolbar element.
   * @param hostElement - the host element of "ontotext-yasgui-web-component".
   */
  static getToolbar(hostElement) {
    return hostElement.querySelector('.yasgui-toolbar');
  }
  /**
   * Fetches the toolbar element.
   * @param hostElement - the host element of "ontotext-yasgui-web-component".
   */
  static getControlBar(hostElement) {
    return hostElement.querySelector('.yasgui .controlbar');
  }
  static toggleHiddenByCondition(hostElement, elementSelectors, haveToExist) {
    HtmlElementsUtil.toggleClassByCondition(hostElement, elementSelectors, 'hidden', haveToExist);
  }
  static toggleClassByCondition(hostElement, elementSelectors, className, haveToExist) {
    elementSelectors.forEach((elementSelector) => {
      const element = hostElement.querySelector(elementSelector);
      if (element) {
        element.classList.toggle(className, haveToExist());
      }
    });
  }
  static createAutocompleteHintElement(text) {
    const hint = document.createElement('span');
    hint.innerHTML = text;
    hint.style.fontSize = '12px';
    hint.style.color = "gray";
    hint.style.backgroundColor = 'white';
    hint.style.position = 'absolute';
    hint.style.zIndex = '3';
    hint.style.paddingLeft = 6 + 'px';
    return hint;
  }
}
