import { Orientation } from '../../models/yasgui-configuration';
import { VisualisationUtils } from '../utils/visualisation-utils';
import { HtmlElementsUtil } from '../utils/html-elements-util';
import { TranslationService } from '../translation.service';
export class OntotextYasguiService {
  constructor(serviceFactory) {
    this.translationService = serviceFactory.get(TranslationService);
  }
  postConstruct(hostElement, config) {
    OntotextYasguiService.initEditorTabs(hostElement, config);
    OntotextYasguiService.initControlBar(hostElement, config);
    OntotextYasguiService.initResultTabs(hostElement, config);
    OntotextYasguiService.initResultInfo(hostElement, config);
    OntotextYasguiService.initButtonsStyling(hostElement, config);
    this.updateTranslation(config);
  }
  updateTranslation(config) {
    if (config.i18n) {
      this.translationService.addTranslations(config.i18n);
    }
  }
  static initEditorTabs(hostElement, config) {
    if (config.showEditorTabs) {
      hostElement.classList.remove('hidden-editor-tabs');
    }
    else {
      hostElement.classList.add('hidden-editor-tabs');
    }
  }
  static initControlBar(hostElement, config) {
    const ontotextYasgui = HtmlElementsUtil.getOntotextYasgui(hostElement);
    if (config.showControlBar) {
      ontotextYasgui.classList.remove('hidden-control-bar');
    }
    else {
      ontotextYasgui.classList.add('hidden-control-bar');
    }
  }
  static initResultTabs(hostElement, config) {
    // TODO: this can be improved by getting the registered plugins directly from the yasr instead of hard-coding them here
    const pluginTabsElementsSelectors = ['.select_extended_table', '.select_extended_response', '.select_charts', '.select_pivot-table-plugin'];
    HtmlElementsUtil.toggleHiddenByCondition(hostElement, pluginTabsElementsSelectors, () => !config.showResultTabs);
  }
  static initResultInfo(hostElement, config) {
    const responseInfoMessageElementsSelectors = ['.yasr_response_chip', '#yasr_plugin_control'];
    HtmlElementsUtil.toggleHiddenByCondition(hostElement, responseInfoMessageElementsSelectors, () => !config.yasguiConfig.yasr.showResultInfo);
  }
  static initButtonsStyling(hostElement, config) {
    // Initialize render buttons styling.
    VisualisationUtils.changeRenderMode(hostElement, config.render, config.orientation === Orientation.VERTICAL);
    // Initialize orientation button styling.
    const orientation = config.orientation;
    VisualisationUtils.toggleLayoutOrientationButton(hostElement, orientation);
    if (config.showToolbar) {
      HtmlElementsUtil.getToolbar(hostElement).classList.remove('hidden');
    }
    else {
      HtmlElementsUtil.getToolbar(hostElement).classList.add('hidden');
    }
  }
}
