import { ChartsPlugin } from "../../../plugins/yasr/charts/charts-plugin";
import { HtmlUtil } from "../../utils/html-util";
export class ChartDownloadPlugin {
  createElement(yasr) {
    const downloadAsElement = document.createElement('button');
    downloadAsElement.className = 'chart-download-as-button icon-download';
    downloadAsElement.onclick = this.onClick(yasr);
    this.updateElement(downloadAsElement, yasr);
    return downloadAsElement;
  }
  updateElement(element, yasr) {
    // if we don't have a configuration for that plugin or no results are present we hide the button.
    element.classList.toggle('hidden', !yasr.results || ChartsPlugin.PLUGIN_NAME !== yasr.getSelectedPluginName());
    element.innerHTML = `<span class="chart-download-as-button-label">${yasr.translationService.translate('yasr.plugin_control.download_as.charts.dropdown.label')}</span>`;
  }
  getOrder() {
    return 0;
  }
  destroy(_element, _yasr) {
    // destroy it
  }
  onClick(yasr) {
    return () => {
      if (!yasr.results) {
        return;
      }
      const selectedPlugin = yasr.getSelectedPlugin();
      if (ChartsPlugin.PLUGIN_NAME === selectedPlugin.label) {
        const downloadInfo = selectedPlugin.download();
        if (downloadInfo) {
          HtmlUtil.downloadStringAsFile(downloadInfo.getData(), downloadInfo.filename, downloadInfo.contentType);
        }
      }
    };
  }
}
