import { TranslationService } from '../../translation.service';
import { QueryType } from '../../../models/yasgui/query-type';
export class DownloadAsYasrToolbarPlugin {
  constructor(serviceFactory, externalPluginsConfigurations) {
    this.translationService = serviceFactory.get(TranslationService);
    this.pluginNameToPluginsConfigurations = new Map();
    this.pluginNameToPluginsConfigurations.set('extended_table', new ExtendedTableDownloadAsConfiguration());
    this.pluginNameToPluginsConfigurations.set('extended_response', new DefaultDownloadAsConfiguration('extended_response'));
    if (!externalPluginsConfigurations) {
      return;
    }
    Object.keys(externalPluginsConfigurations).forEach((pluginName) => {
      const pluginConfiguration = this.toDownloadAsPluginConfiguration(pluginName, externalPluginsConfigurations[pluginName]);
      this.pluginNameToPluginsConfigurations.set(pluginConfiguration.getPluginName(), pluginConfiguration);
    });
  }
  createElement(yasr) {
    const downloadAsElement = document.createElement("ontotext-download-as");
    downloadAsElement.translationService = this.translationService;
    this.updateDownloadAsElementVisibility(downloadAsElement, yasr);
    return downloadAsElement;
  }
  updateElement(element, yasr) {
    var _a, _b, _c;
    if (!element) {
      return;
    }
    element.query = (_a = yasr.yasqe) === null || _a === void 0 ? void 0 : _a.getValueWithoutComments();
    element.pluginName = yasr.getSelectedPluginName();
    const infer = (_b = yasr.yasqe) === null || _b === void 0 ? void 0 : _b.getInfer();
    if (infer !== undefined) {
      element.infer = infer;
    }
    const sameAs = (_c = yasr.yasqe) === null || _c === void 0 ? void 0 : _c.getSameAs();
    if (sameAs !== undefined) {
      element.sameAs = sameAs;
    }
    const downloadAsConfiguration = this.pluginNameToPluginsConfigurations.get(element.pluginName);
    if (downloadAsConfiguration) {
      element.items = downloadAsConfiguration.getOptions(yasr);
      element.nameLabelKey = downloadAsConfiguration.getNameLabelKey();
      element.tooltipLabelKey = downloadAsConfiguration.getTooltipLabelKey();
    }
    else {
      element.items = [];
    }
    this.updateDownloadAsElementVisibility(element, yasr);
  }
  getOrder() {
    return 0;
  }
  destroy(_element) {
    // Nothing to do at the moment.
  }
  toDownloadAsPluginConfiguration(pluginName, externalConfiguration) {
    if (externalConfiguration && externalConfiguration.downloadAsConfig && externalConfiguration.downloadAsConfig.items) {
      const pluginConfiguration = new DownloadAsPluginConfiguration(pluginName, externalConfiguration.nameLabelKey, externalConfiguration.tooltipLabelKey);
      pluginConfiguration.setOptions(externalConfiguration.downloadAsConfig.items);
      return pluginConfiguration;
    }
  }
  updateDownloadAsElementVisibility(element, yasr) {
    var _a, _b;
    element.classList.add("hidden");
    const downloadAsConfiguration = this.pluginNameToPluginsConfigurations.get(element.pluginName);
    if (!downloadAsConfiguration) {
      // if we don't have a configuration for that plugin, we hidde the button.
      return;
    }
    // Download as dropdown is not visible
    // when executed query is for explain plan query,
    if (yasr.yasqe.isExplainPlanQuery()) {
      return;
    }
    // or there is no results.
    if (!((_b = (_a = yasr.results) === null || _a === void 0 ? void 0 : _a.getBindings()) === null || _b === void 0 ? void 0 : _b.length)) {
      return;
    }
    element.classList.remove("hidden");
  }
}
class DownloadAsPluginConfiguration {
  constructor(pluginName, nameLabelKey, tooltipLabelKey) {
    this.pluginName = pluginName;
    this.nameLabelKey = nameLabelKey;
    this.tooltipLabelKey = tooltipLabelKey || nameLabelKey;
  }
  getPluginName() {
    return this.pluginName;
  }
  getNameLabelKey() {
    return this.nameLabelKey;
  }
  getTooltipLabelKey() {
    return this.tooltipLabelKey;
  }
  //@ts-ignore
  getOptions(yasr) {
    if (this.options) {
      //@ts-ignore
      return this.options[yasr.yasqe.getQueryType()];
    }
    return [];
  }
  setOptions(options) {
    this.options = options;
  }
}
class DefaultDownloadAsConfiguration extends DownloadAsPluginConfiguration {
  constructor(pluginName) {
    super(pluginName, 'yasr.plugin_control.download_as.raw_response.dropdown.label');
  }
  //@ts-ignore
  getOptions(yasr) {
    switch (yasr.yasqe.getQueryType()) {
      case QueryType.SELECT:
      case QueryType.CONSTRUCT:
      case QueryType.DESCRIBE:
        return [{
            labelKey: "yasr.plugin_control.download_as.sparql_results_json.label",
            value: "application/sparql-results+json",
          }, {
            labelKey: "yasr.plugin_control.download_as.csv.label",
            value: "text/csv",
          }];
      default:
        return [];
    }
  }
}
class ExtendedTableDownloadAsConfiguration extends DownloadAsPluginConfiguration {
  constructor() {
    super('extended_table', 'yasr.plugin_control.download_as.extended_table.dropdown.label');
  }
  //@ts-ignore
  getOptions(yasr) {
    switch (yasr.yasqe.getQueryType()) {
      case 'SELECT':
        return [{
            labelKey: "yasr.plugin_control.download_as.sparql_results_json.label",
            value: "application/sparql-results+json",
          }, {
            labelKey: "yasr.plugin_control.download_as.x_sparqlstar_results_json.label",
            value: "application/x-sparqlstar-results+json",
          }, {
            labelKey: 'yasr.plugin_control.download_as.sparql_results_xml.label',
            value: 'application/sparql-results+xml'
          }, {
            labelKey: 'yasr.plugin_control.download_as.x_sparqlstar_results_xml.label',
            value: 'application/x-sparqlstar-results+xml'
          }, {
            labelKey: "yasr.plugin_control.download_as.csv.label",
            value: "text/csv",
          }, {
            labelKey: "yasr.plugin_control.download_as.tab_separated_values.label",
            value: "text/tab-separated-values",
          }, {
            labelKey: "yasr.plugin_control.download_as.x_tab_separated_values_star.label",
            value: "text/x-tab-separated-values-star",
          }, {
            labelKey: "yasr.plugin_control.download_as.x_binary_rdf_results_table.label",
            value: "application/x-binary-rdf-results-table",
          }];
      case 'CONSTRUCT':
      case 'DESCRIBE':
        return [{
            labelKey: "yasr.plugin_control.download_as.sparql_results_json.label",
            value: "application/rdf+json",
          }, {
            labelKey: "yasr.plugin_control.download_as.sparql_results_json_ld.label",
            value: "application/ld+json",
          }, {
            labelKey: "yasr.plugin_control.download_as.sparql_results_ndjson_ld.label",
            value: "application/x-ld+ndjson",
          }, {
            labelKey: "yasr.plugin_control.download_as.x_sparqlstar_results_rdf_xml.label",
            value: "application/rdf+xml",
          }, {
            labelKey: "yasr.plugin_control.download_as.n3.label",
            value: "text/rdf+n3",
          }, {
            labelKey: "yasr.plugin_control.download_as.n_triples.label",
            value: "text/plain",
          }, {
            labelKey: "yasr.plugin_control.download_as.n_quads.label",
            value: "text/x-nquads",
          }, {
            labelKey: "yasr.plugin_control.download_as.triple.label",
            value: "text/turtle",
          }, {
            labelKey: "yasr.plugin_control.download_as.triple_star.label",
            value: "application/x-turtlestar",
          }, {
            labelKey: "yasr.plugin_control.download_as.tri-x.label",
            value: "application/trix",
          }, {
            labelKey: "yasr.plugin_control.download_as.tri-g.label",
            value: "application/x-trig",
          }, {
            labelKey: "yasr.plugin_control.download_as.tri-g_star.label",
            value: "application/x-trigstar",
          }, {
            labelKey: "yasr.plugin_control.download_as.binary.label",
            value: "application/x-binary-rdf",
          }];
      default:
        return [];
    }
  }
}
