export class PaginationYasrToolbarPlugin {
  constructor() {
    this.yasrIdToEventListenerMapper = new Map();
  }
  createElement(yasr) {
    const element = document.createElement("ontotext-pagination");
    const pageSelectedListener = this.pageSelectedHandler(yasr);
    this.yasrIdToEventListenerMapper.set(yasr.getTabId(), pageSelectedListener);
    element.addEventListener("pageSelected", pageSelectedListener);
    return element;
  }
  updateElement(element, yasr) {
    var _a, _b, _c, _d, _e, _f, _g, _h;
    const paginationElement = element;
    paginationElement.pageNumber = (_a = yasr.yasqe) === null || _a === void 0 ? void 0 : _a.getPageNumber();
    paginationElement.pageSize = (_b = yasr.yasqe) === null || _b === void 0 ? void 0 : _b.getPageSize();
    paginationElement.pageElements = ((_d = (_c = yasr.results) === null || _c === void 0 ? void 0 : _c.getBindings()) === null || _d === void 0 ? void 0 : _d.length) || 0;
    const totalElements = ((_f = (_e = yasr.persistentJson) === null || _e === void 0 ? void 0 : _e.yasr.response) === null || _f === void 0 ? void 0 : _f.totalElements) || ((_g = yasr.results) === null || _g === void 0 ? void 0 : _g.totalElements);
    if (totalElements) {
      paginationElement.totalElements = totalElements;
    }
    paginationElement.hasMorePages = (_h = yasr.results) === null || _h === void 0 ? void 0 : _h.getHasMorePages();
    this.updateQueryResultPaginationVisibility(paginationElement, yasr);
  }
  getOrder() {
    return 100000;
  }
  //@ts-ignore
  destroy(element, yasr) {
    const eventHandler = this.yasrIdToEventListenerMapper.get(yasr.getTabId());
    if (eventHandler) {
      element.removeEventListener('pageSelected', eventHandler);
    }
  }
  updateQueryResultPaginationVisibility(resultQueryPaginationElement, yasr) {
    var _a, _b;
    resultQueryPaginationElement.classList.add('hidden');
    // Pagination is not visible
    // when executed query is for explain plan query,
    if (yasr.yasqe.isExplainPlanQuery()) {
      return;
    }
    // or pagination is on first page and page hasn't results,
    const hasNotResults = !((_b = (_a = yasr.results) === null || _a === void 0 ? void 0 : _a.getBindings()) === null || _b === void 0 ? void 0 : _b.length);
    if (hasNotResults && resultQueryPaginationElement.pageNumber === 1) {
      return;
    }
    // or has fewer results than one page.
    if (!this.hasMoreThanOnePageElements(resultQueryPaginationElement)) {
      return;
    }
    resultQueryPaginationElement.classList.remove('hidden');
  }
  hasMoreThanOnePageElements(resultQueryPaginationElement) {
    if (resultQueryPaginationElement.pageNumber && resultQueryPaginationElement.pageNumber > 1) {
      return true;
    }
    if (resultQueryPaginationElement.hasMorePages !== undefined) {
      return resultQueryPaginationElement.hasMorePages;
    }
    if (resultQueryPaginationElement.pageSize && resultQueryPaginationElement.totalElements) {
      return resultQueryPaginationElement.pageSize < resultQueryPaginationElement.totalElements;
    }
    return false;
  }
  pageSelectedHandler(yasr) {
    return (pageEvent) => {
      const page = pageEvent.detail;
      const yasqe = yasr.yasqe;
      if (yasqe) {
        yasqe.setPageNumber(page.pageNumber || 1);
        yasqe.setPageSize(page.pageSize || 10);
        yasqe
          .query()
          .then()
          .catch(() => {
          // catch this to avoid unhandled rejection
        });
      }
    };
  }
}
