import { proxyCustomElement, HTMLElement, h, Host } from '@stencil/core/internal/client';

const alertBoxCss = ".alert-box{position:relative}.alert-box .close-button{position:absolute;top:10px;right:10px;cursor:pointer;font-size:21px;font-weight:700;line-height:1;color:#8a6d3b;opacity:0.2}.alert-box .close-button:hover{text-decoration:none;color:#000;opacity:0.5}";

const AlertBox$1 = /*@__PURE__*/ proxyCustomElement(class extends HTMLElement {
  constructor() {
    super();
    this.__registerHost();
    this.type = 'info';
    this.message = undefined;
    this.noIcon = true;
    this.noButton = false;
    this.isVisible = true;
  }
  onClose(evt) {
    evt.stopPropagation();
    this.isVisible = !this.isVisible;
  }
  render() {
    const classList = `alert-box alert alert-${this.type} ${this.noIcon && 'no-icon'}`;
    return (h(Host, null, this.isVisible && h("div", { class: classList }, !this.noButton && h("a", { class: "close-button", onClick: (evt) => this.onClose(evt) }, "\u00D7"), h("div", { class: "message" }, this.message))));
  }
  static get style() { return alertBoxCss; }
}, [0, "alert-box", {
    "type": [1],
    "message": [1],
    "noIcon": [4, "no-icon"],
    "noButton": [4, "no-button"],
    "isVisible": [32]
  }]);
function defineCustomElement$1() {
  if (typeof customElements === "undefined") {
    return;
  }
  const components = ["alert-box"];
  components.forEach(tagName => { switch (tagName) {
    case "alert-box":
      if (!customElements.get(tagName)) {
        customElements.define(tagName, AlertBox$1);
      }
      break;
  } });
}

const AlertBox = AlertBox$1;
const defineCustomElement = defineCustomElement$1;

export { AlertBox, defineCustomElement };
