import { proxyCustomElement, HTMLElement, h, Host } from '@stencil/core/internal/client';
import { E as EventService } from './event-service.js';
import { I as InternalEventType } from './internal-dropdown-value-selected-event.js';

const copyResourceLinkButtonCss = ".copy-resource-link-button a.icon-link:hover{text-decoration:none}";

const CopyResourceLinkButton$1 = /*@__PURE__*/ proxyCustomElement(class extends HTMLElement {
  constructor() {
    super();
    this.__registerHost();
    this.uri = undefined;
    this.classes = undefined;
  }
  onButtonClick() {
    EventService.emitFromInnerElement(this.hostElement, InternalEventType.INTERNAL_SHOW_RESOURCE_COPY_LINK_DIALOG_EVENT, { copyLink: this.uri });
  }
  render() {
    const classList = `copy-resource-link-button ${this.classes || ''}`;
    return (h(Host, { class: classList }, h("a", { class: "icon-link", href: "#", onClick: () => this.onButtonClick() })));
  }
  get hostElement() { return this; }
  static get style() { return copyResourceLinkButtonCss; }
}, [0, "copy-resource-link-button", {
    "uri": [1],
    "classes": [1]
  }]);
function defineCustomElement$1() {
  if (typeof customElements === "undefined") {
    return;
  }
  const components = ["copy-resource-link-button"];
  components.forEach(tagName => { switch (tagName) {
    case "copy-resource-link-button":
      if (!customElements.get(tagName)) {
        customElements.define(tagName, CopyResourceLinkButton$1);
      }
      break;
  } });
}

const CopyResourceLinkButton = CopyResourceLinkButton$1;
const defineCustomElement = defineCustomElement$1;

export { CopyResourceLinkButton, defineCustomElement };
