import { proxyCustomElement, HTMLElement, createEvent, h } from '@stencil/core/internal/client';
import { d as defineCustomElement$2 } from './copy-link-dialog2.js';
import { d as defineCustomElement$1 } from './ontotext-dialog-web-component2.js';

const copyResourceLinkDialogCss = "";

const CopyResourceLinkDialog = /*@__PURE__*/ proxyCustomElement(class extends HTMLElement {
  constructor() {
    super();
    this.__registerHost();
    this.internalResourceLinkDialogClosedEvent = createEvent(this, "internalResourceLinkDialogClosedEvent", 7);
    this.internalResourceLinkCopiedEvent = createEvent(this, "internalResourceLinkCopiedEvent", 7);
    this.serviceFactory = undefined;
    this.resourceLink = undefined;
  }
  onDialogClosed() {
    this.internalResourceLinkDialogClosedEvent.emit();
  }
  onLinkCopied() {
    this.internalResourceLinkCopiedEvent.emit();
  }
  render() {
    return (h("copy-link-dialog", { config: { copyLink: this.resourceLink }, classes: "copy-resource-link-dialog", serviceFactory: this.serviceFactory, copyLinkEventsObserver: this }));
  }
  static get style() { return copyResourceLinkDialogCss; }
}, [0, "copy-resource-link-dialog", {
    "serviceFactory": [16],
    "resourceLink": [1, "resource-link"]
  }]);
function defineCustomElement() {
  if (typeof customElements === "undefined") {
    return;
  }
  const components = ["copy-resource-link-dialog", "copy-link-dialog", "ontotext-dialog-web-component"];
  components.forEach(tagName => { switch (tagName) {
    case "copy-resource-link-dialog":
      if (!customElements.get(tagName)) {
        customElements.define(tagName, CopyResourceLinkDialog);
      }
      break;
    case "copy-link-dialog":
      if (!customElements.get(tagName)) {
        defineCustomElement$2();
      }
      break;
    case "ontotext-dialog-web-component":
      if (!customElements.get(tagName)) {
        defineCustomElement$1();
      }
      break;
  } });
}

export { CopyResourceLinkDialog as C, defineCustomElement as d };
