import { proxyCustomElement, HTMLElement, createEvent, h } from '@stencil/core/internal/client';
import { a as InternalDropdownValueSelectedEvent } from './internal-dropdown-value-selected-event.js';
import { d as defineCustomElement$1 } from './ontotext-tooltip-web-component.js';

const dropdownCss = ".ontotext-dropdown .ontotext-dropdown-button{font-size:16px;font-weight:400;padding:5px 16px;line-height:1.25;border:none;outline:none;color:#FFFFFF;background-color:#e84e0f}.ontotext-dropdown .ontotext-dropdown-menu{position:absolute;margin:0;padding:0;z-index:1000}.ontotext-dropdown .ontotext-dropdown-menu-item{display:block;text-decoration:none;font-size:1rem;font-weight:400;padding:0.5em 1.2em;color:#FFFFFF;background-color:#e84e0f}.ontotext-dropdown .ontotext-dropdown-menu-item:hover{text-decoration:none;background-color:#d0460d;color:#ffffff}.ontotext-dropdown .ontotext-dropdown-icon:before{padding-right:5px}.ontotext-dropdown .ontotext-dropdown-button.icon-caret-down-after:after,.ontotext-dropdown .ontotext-dropdown-button.icon-caret-up-after:after{padding-left:10px;color:#00000059}.ontotext-dropdown .ontotext-dropdown-menu.closed{display:none}.ontotext-dropdown .ontotext-dropdown-button:hover{cursor:pointer}@media (max-width: 768px){.ontotext-dropdown .ontotext-dropdown-button:after{padding-left:0 !important}.ontotext-dropdown .button-name{display:none}}";

const Dropdown = /*@__PURE__*/ proxyCustomElement(class extends HTMLElement {
  constructor() {
    super();
    this.__registerHost();
    this.valueChanged = createEvent(this, "valueChanged", 7);
    this.open = false;
    this.showTooltip = false;
    this.translationService = undefined;
    this.nameLabelKey = undefined;
    this.tooltipLabelKey = undefined;
    this.items = undefined;
    this.iconClass = '';
  }
  /**
   * Handles the Escape key keydown event and closes the dialog.
   * @param ev The keyboard event.
   */
  keydownListener(ev) {
    if (ev.key === 'Escape') {
      this.closeMenu();
    }
  }
  /**
   * Handles the mouse click events and closes the menu when target is outside the menu.
   * @param ev The mouse event.
   */
  mouseClickListener(ev) {
    const target = ev.target;
    if (!target.closest('.ontotext-dropdown')) {
      this.closeMenu();
    }
  }
  render() {
    const showToolbar = this.tooltipLabelKey && window.innerWidth < 768;
    const dropdownButtonClass = `ontotext-dropdown-button ${this.open ? 'icon-caret-up-after' : ' icon-caret-down-after'}
    ${this.iconClass ? `ontotext-dropdown-icon ${this.iconClass}` : ''}`;
    return (h("yasgui-tooltip", { "data-tooltip": showToolbar ? this.translate(this.nameLabelKey) : '' }, h("div", { class: 'ontotext-dropdown' }, h("button", { class: dropdownButtonClass, onClick: () => this.toggleComponent() }, h("span", { class: 'button-name' }, this.translate(this.nameLabelKey))), h("div", { class: `ontotext-dropdown-menu ${this.open ? 'open' : 'closed'}` }, this.items && this.items.map(item => h("a", { href: "#", class: 'ontotext-dropdown-menu-item', onClick: () => this.onSelect(item.value) }, this.translate(item.labelKey)))))));
  }
  onSelect(value) {
    this.open = false;
    this.valueChanged.emit(new InternalDropdownValueSelectedEvent(value));
  }
  toggleComponent() {
    this.open = !this.open;
  }
  translate(labelKey) {
    if (this.translationService) {
      return this.translationService.translate(labelKey);
    }
    return '';
  }
  closeMenu() {
    this.open = false;
  }
  static get style() { return dropdownCss; }
}, [0, "ontotext-dropdown", {
    "translationService": [16],
    "nameLabelKey": [1, "name-label-key"],
    "tooltipLabelKey": [1, "tooltip-label-key"],
    "items": [16],
    "iconClass": [1, "icon-class"],
    "open": [32],
    "showTooltip": [32]
  }, [[8, "keydown", "keydownListener"], [8, "click", "mouseClickListener"]]]);
function defineCustomElement() {
  if (typeof customElements === "undefined") {
    return;
  }
  const components = ["ontotext-dropdown", "yasgui-tooltip"];
  components.forEach(tagName => { switch (tagName) {
    case "ontotext-dropdown":
      if (!customElements.get(tagName)) {
        customElements.define(tagName, Dropdown);
      }
      break;
    case "yasgui-tooltip":
      if (!customElements.get(tagName)) {
        defineCustomElement$1();
      }
      break;
  } });
}

export { Dropdown as D, defineCustomElement as d };
