/* OntotextYasguiWebComponent custom elements */
export { AlertBox as AlertBox } from '../types/components/alert-box/alert-box';
export { ConfirmationDialog as ConfirmationDialog } from '../types/components/confirmation-dialog/confirmation-dialog';
export { CopyLinkDialog as CopyLinkDialog } from '../types/components/copy-link-dialog/copy-link-dialog';
export { CopyResourceLinkButton as CopyResourceLinkButton } from '../types/components/copy-resource-link-button/copy-resource-link-button';
export { CopyResourceLinkDialog as CopyResourceLinkDialog } from '../types/components/copy-resource-link-dialog/copy-resource-link-dialog';
export { KeyboardShortcutsDialog as KeyboardShortcutsDialog } from '../types/components/keyboard-shortcuts-dialog/keyboard-shortcuts-dialog';
export { LoaderComponent as LoaderComponent } from '../types/components/loader-component/loader-component';
export { OntotextDialogWebComponent as OntotextDialogWebComponent } from '../types/components/ontotext-dialog-web-component/ontotext-dialog-web-component';
export { DownloadAs as OntotextDownloadAs } from '../types/components/download-as/download-as';
export { Dropdown as OntotextDropdown } from '../types/components/dropdown/dropdown';
export { OntotextEditableTextField as OntotextEditableTextField } from '../types/components/ontotext-editable-text-field/ontotext-editable-text-field.component';
export { Pagination as OntotextPagination } from '../types/components/pagination/pagination';
export { OntotextYasguiWebComponent as OntotextYasgui } from '../types/components/ontotext-yasgui-web-component/ontotext-yasgui-web-component';
export { SaveQueryDialog as SaveQueryDialog } from '../types/components/save-query-dialog/save-query-dialog';
export { SavedQueriesPopup as SavedQueriesPopup } from '../types/components/saved-queries-popup/saved-queries-popup';
export { ShareQueryDialog as ShareQueryDialog } from '../types/components/share-query-dialog/share-query-dialog';
export { OntotextTooltipWebComponent as YasguiTooltip } from '../types/components/ontotext-tooltip-web-component/ontotext-tooltip-web-component';

/**
 * Used to manually set the base path where assets can be found.
 * If the script is used as "module", it's recommended to use "import.meta.url",
 * such as "setAssetPath(import.meta.url)". Other options include
 * "setAssetPath(document.currentScript.src)", or using a bundler's replace plugin to
 * dynamically set the path at build time, such as "setAssetPath(process.env.ASSET_PATH)".
 * But do note that this configuration depends on how your script is bundled, or lack of
 * bundling, and where your assets can be loaded from. Additionally custom bundling
 * will have to ensure the static assets are copied to its build directory.
 */
export declare const setAssetPath: (path: string) => void;

export interface SetPlatformOptions {
  raf?: (c: FrameRequestCallback) => number;
  ael?: (el: EventTarget, eventName: string, listener: EventListenerOrEventListenerObject, options: boolean | AddEventListenerOptions) => void;
  rel?: (el: EventTarget, eventName: string, listener: EventListenerOrEventListenerObject, options: boolean | AddEventListenerOptions) => void;
}
export declare const setPlatformOptions: (opts: SetPlatformOptions) => void;
export * from '../types';
