import { proxyCustomElement, HTMLElement, h, Host } from '@stencil/core/internal/client';
import { d as defineCustomElement$2 } from './ontotext-dialog-web-component2.js';

const keyboardShortcutsDialogCss = ".keyboard-shortcuts-dialog-wrapper{display:flex;justify-content:flex-end;margin-top:-9px;margin-right:1px;z-index:1015}.keyboard-shortcuts-dialog-wrapper .keyboard-shortcuts-dialog-button{background-color:#f7f7f7;outline:none;border:0.5px solid #EBEBEB;cursor:pointer;position:relative;z-index:1015}.keyboard-shortcuts-dialog-wrapper .dialog{min-width:80vw}.keyboard-shortcuts-dialog-wrapper .dialog .dialog-footer{display:none}.keyboard-shortcuts-dialog-wrapper .keyboard-shortcut-description-item{display:flex;flex-direction:row;gap:10px;padding-bottom:10px}.keyboard-shortcuts-dialog-wrapper .keyboard-shortcut-description-item-label{width:50%;text-align:end;font-size:14px}.keyboard-shortcuts-dialog-wrapper .keyboard-shortcut-description-item-label span{color:#fff;background-color:#333;border-radius:0.2rem;padding:4px}.keyboard-shortcuts-dialog-wrapper .keyboard-shortcut-description-item-description{width:50%;font-size:20px}.keyboard-shortcuts-dialog-wrapper kbd{background-color:#FFF}.keyboard-shortcuts-dialog-wrapper.resizeable-on{margin-top:-29px}.yasqe-fullscreen .keyboard-shortcuts-dialog-wrapper .keyboard-shortcuts-dialog-button{position:fixed;bottom:0;right:0}";

const KeyboardShortcutsDialog$1 = /*@__PURE__*/ proxyCustomElement(class extends HTMLElement {
  constructor() {
    super();
    this.__registerHost();
    this.open = undefined;
    this.items = [];
    this.translationService = undefined;
  }
  /**
   * Handles the Escape key keydown event and closes the dialog.
   * @param ev The keyboard event.
   */
  keydownListener(ev) {
    if (ev.key === 'Escape') {
      this.open = false;
    }
  }
  openDialog() {
    this.open = true;
  }
  closeDialog(evt) {
    const target = evt.target;
    evt.stopPropagation();
    if (target.classList.contains('close-button') || target.classList.contains('dialog-overlay')) {
      this.open = false;
    }
  }
  buildDialogConfig() {
    return {
      dialogTitle: this.translationService.translate('yasqe.keyboard_shortcuts.dialog.title'),
      onClose: this.closeDialog.bind(this)
    };
  }
  translateLabel(keyboardShortcutName) {
    return this.translate(`yasqe.keyboard_shortcuts.dialog.item.${keyboardShortcutName}.label`);
  }
  translateDescription(keyboardShortcutName) {
    return this.translate(`yasqe.keyboard_shortcuts.dialog.item.${keyboardShortcutName}.description`);
  }
  translate(labelKey) {
    if (this.translationService) {
      return this.translationService.translate(labelKey);
    }
    return labelKey;
  }
  render() {
    return (h(Host, { class: 'keyboard-shortcuts-dialog-wrapper' }, this.open &&
      h("ontotext-dialog-web-component", { config: this.buildDialogConfig() }, h("div", { slot: "body" }, this.items.map(keyboardShortcutDescriptionLabelKey => h("div", { class: 'keyboard-shortcut-description-item' }, h("kbd", { class: 'keyboard-shortcut-description-item-label' }, h("span", null, this.translateLabel(keyboardShortcutDescriptionLabelKey))), h("div", { class: 'keyboard-shortcut-description-item-description' }, this.translateDescription(keyboardShortcutDescriptionLabelKey)))))), !this.open && h("button", { class: 'keyboard-shortcuts-dialog-button', onClick: () => this.openDialog() }, this.translate('yasqe.keyboard_shortcuts.btn.label'))));
  }
  static get style() { return keyboardShortcutsDialogCss; }
}, [0, "keyboard-shortcuts-dialog", {
    "items": [16],
    "translationService": [16],
    "open": [32]
  }, [[8, "keydown", "keydownListener"]]]);
function defineCustomElement$1() {
  if (typeof customElements === "undefined") {
    return;
  }
  const components = ["keyboard-shortcuts-dialog", "ontotext-dialog-web-component"];
  components.forEach(tagName => { switch (tagName) {
    case "keyboard-shortcuts-dialog":
      if (!customElements.get(tagName)) {
        customElements.define(tagName, KeyboardShortcutsDialog$1);
      }
      break;
    case "ontotext-dialog-web-component":
      if (!customElements.get(tagName)) {
        defineCustomElement$2();
      }
      break;
  } });
}

const KeyboardShortcutsDialog = KeyboardShortcutsDialog$1;
const defineCustomElement = defineCustomElement$1;

export { KeyboardShortcutsDialog, defineCustomElement };
