import { proxyCustomElement, HTMLElement, h, Host } from '@stencil/core/internal/client';
import { S as SvgUtil } from './svg-util.js';

const loaderComponentCss = ":host{display:block}:host .loader-component{text-align:center}";

const LoaderComponent$1 = /*@__PURE__*/ proxyCustomElement(class extends HTMLElement {
  constructor() {
    super();
    this.__registerHost();
    this.__attachShadow();
    this.timeFormattingService = undefined;
    this.showQueryProgress = false;
    this.message = undefined;
    this.additionalMessage = '';
    this.size = undefined;
    this.hidden = undefined;
    this.queryProgress = '';
  }
  startInterval() {
    this.updateState();
  }
  updateState() {
    if (this.hidden) {
      this.clearLoader();
      this.hostElement.classList.add('hidden');
    }
    else {
      this.hostElement.classList.remove('hidden');
      if (this.showQueryProgress && !this.updateLoaderInterval) {
        this.queryProgress = '';
        this.startTime = Date.now();
        this.updateLoaderMessage();
        this.updateLoaderInterval = setInterval(() => {
          this.updateLoaderMessage();
        }, 1000);
      }
    }
  }
  updateLoaderMessage() {
    if (this.showQueryProgress) {
      const durationTime = (Date.now() - this.startTime);
      const durationTimeInSeconds = durationTime / 1000;
      if (durationTimeInSeconds > 10) {
        this.queryProgress = LoaderComponent$1.EMPTY_QUERY_PROGRESS + this.timeFormattingService.getHumanReadableSeconds(durationTime);
      }
    }
    else {
      this.clearLoader();
    }
  }
  componentDidLoad() {
    // As documentation said "The @Watch() decorator does not fire when a component initially loads."
    // yasgui instance will not be created if we set configuration when component is loaded, which
    // will be most case of the component usage. So we call the method manually when component is
    // loaded. More info https://github.com/TriplyDB/Yasgui/issues/143
    this.updateState();
  }
  disconnectedCallback() {
    this.clearLoader();
  }
  clearLoader() {
    if (this.updateLoaderInterval) {
      clearInterval(this.updateLoaderInterval);
      this.updateLoaderInterval = null;
    }
    this.queryProgress = '';
  }
  render() {
    return (h(Host, { class: 'ontotext-yasgui-loader hidden' }, h("slot", null, !this.hidden &&
      h("div", { class: 'loader-component' }, h("div", { innerHTML: SvgUtil.getLoaderSvgTag(this.size) }), h("div", null, this.message, " ", this.queryProgress), h("div", null, this.additionalMessage)))));
  }
  get hostElement() { return this; }
  static get watchers() { return {
    "hidden": ["startInterval"]
  }; }
  static get style() { return loaderComponentCss; }
}, [1, "loader-component", {
    "timeFormattingService": [16],
    "showQueryProgress": [4, "show-query-progress"],
    "message": [1],
    "additionalMessage": [1, "additional-message"],
    "size": [1],
    "hidden": [4],
    "queryProgress": [32]
  }]);
LoaderComponent$1.EMPTY_QUERY_PROGRESS = '... ';
function defineCustomElement$1() {
  if (typeof customElements === "undefined") {
    return;
  }
  const components = ["loader-component"];
  components.forEach(tagName => { switch (tagName) {
    case "loader-component":
      if (!customElements.get(tagName)) {
        customElements.define(tagName, LoaderComponent$1);
      }
      break;
  } });
}

const LoaderComponent = LoaderComponent$1;
const defineCustomElement = defineCustomElement$1;

export { LoaderComponent, defineCustomElement };
