import { proxyCustomElement, HTMLElement, h, Host } from '@stencil/core/internal/client';
import { H as HtmlUtil } from './html-util.js';

const ontotextDialogWebComponentCss = ".dialog-overlay{position:fixed;top:0;bottom:0;left:0;right:0;display:flex;align-items:center;justify-content:center;z-index:9998;margin-left:-10px;background-color:rgba(0, 0, 0, 0.5);font-family:\"Roboto\", \"Helvetica Neue\", Arial, sans-serif;font-weight:300;color:#373a3c}.dialog{z-index:1001;max-width:90vw;max-height:90vh;background-color:#FFF;box-shadow:0 5px 15px rgba(0, 0, 0, 0.5);font-family:inherit;font-weight:inherit;display:flex;flex-direction:column;position:unset}.dialog .dialog-header{display:flex;justify-content:space-between;padding:15px;border-bottom:1px solid #e5e5e5;font-size:20px}.dialog .dialog-header .dialog-title{margin:0.5rem 0;font-weight:400}.dialog .dialog-header .close-button{background-color:#fff;border:none;outline:none;cursor:pointer}.dialog .dialog-header .close-button:hover,.dialog .dialog-header .close-button:focus{font-weight:bold}.dialog .dialog-body{padding:15px;overflow:auto}.dialog .dialog-footer{display:flex;justify-content:flex-end;padding:15px;border-top:1px solid #e5e5e5}";

const OntotextDialogWebComponent = /*@__PURE__*/ proxyCustomElement(class extends HTMLElement {
  constructor() {
    super();
    this.__registerHost();
    this.config = undefined;
  }
  /**
   * Handles the Escape key keydown event and closes the dialog.
   * @param ev The keyboard event.
   */
  keydownListener(ev) {
    if (ev.key === 'Escape') {
      this.closeButton.click();
    }
  }
  componentDidLoad() {
    this.documentOverflow = HtmlUtil.hideDocumentBodyOverflow();
    this.hostElement.addEventListener('keydown', this.preventLeavingDialog.bind(this));
    this.closeButton.focus();
  }
  disconnectedCallback() {
    this.hostElement.removeEventListener('keydown', this.preventLeavingDialog.bind(this));
    HtmlUtil.setDocumentBodyOverflow(this.documentOverflow);
  }
  preventLeavingDialog(ev) {
    HtmlUtil.preventLeavingDialog(this.hostElement, ev);
  }
  render() {
    return (h(Host, { tabindex: '-1' }, h("div", { class: "dialog-overlay", onClick: (evt) => this.config.onClose(evt) }, h("div", { class: "dialog" }, h("div", { class: "dialog-header" }, h("h3", { class: "dialog-title" }, this.config.dialogTitle), h("button", { class: "close-button icon-close", onClick: (evt) => this.config.onClose(evt), ref: (el) => (this.closeButton = el) })), h("div", { class: "dialog-body" }, h("slot", { name: "body" })), h("div", { class: "dialog-footer" }, h("slot", { name: "footer" }))))));
  }
  get hostElement() { return this; }
  static get style() { return ontotextDialogWebComponentCss; }
}, [4, "ontotext-dialog-web-component", {
    "config": [16]
  }, [[4, "keydown", "keydownListener"]]]);
function defineCustomElement() {
  if (typeof customElements === "undefined") {
    return;
  }
  const components = ["ontotext-dialog-web-component"];
  components.forEach(tagName => { switch (tagName) {
    case "ontotext-dialog-web-component":
      if (!customElements.get(tagName)) {
        customElements.define(tagName, OntotextDialogWebComponent);
      }
      break;
  } });
}

export { OntotextDialogWebComponent as O, defineCustomElement as d };
