import { proxyCustomElement, HTMLElement, createEvent, h } from '@stencil/core/internal/client';
import { I as InternalDownloadAsEvent } from './internal-download-as-event.js';
import { d as defineCustomElement$3 } from './dropdown.js';
import { d as defineCustomElement$2 } from './ontotext-tooltip-web-component.js';

const downloadAsCss = "";

const DownloadAs = /*@__PURE__*/ proxyCustomElement(class extends HTMLElement {
  constructor() {
    super();
    this.__registerHost();
    this.downloadAs = createEvent(this, "internalDownloadAsEvent", 7);
    this.translationService = undefined;
    this.nameLabelKey = undefined;
    this.tooltipLabelKey = undefined;
    this.items = undefined;
    this.pluginName = undefined;
    this.query = undefined;
    this.infer = undefined;
    this.sameAs = undefined;
  }
  onInternalDropdownValueSelected(event) {
    this.downloadAs.emit(new InternalDownloadAsEvent(event.detail.payload.value, this.pluginName, this.query, this.infer, this.sameAs));
  }
  render() {
    return (h("ontotext-dropdown", { class: 'ontotext-download-as', onValueChanged: ev => this.onInternalDropdownValueSelected(ev), translationService: this.translationService, tooltipLabelKey: this.tooltipLabelKey, nameLabelKey: this.nameLabelKey ? this.nameLabelKey : DownloadAs.DEFAULT_NAME_LABEL, iconClass: 'icon-download', items: this.items }));
  }
  static get style() { return downloadAsCss; }
}, [0, "ontotext-download-as", {
    "translationService": [16],
    "nameLabelKey": [1, "name-label-key"],
    "tooltipLabelKey": [1, "tooltip-label-key"],
    "items": [16],
    "pluginName": [1, "plugin-name"],
    "query": [1],
    "infer": [4],
    "sameAs": [4, "same-as"]
  }]);
DownloadAs.DEFAULT_NAME_LABEL = 'yasr.plugin_control.download_results.btn.label';
function defineCustomElement$1() {
  if (typeof customElements === "undefined") {
    return;
  }
  const components = ["ontotext-download-as", "ontotext-dropdown", "yasgui-tooltip"];
  components.forEach(tagName => { switch (tagName) {
    case "ontotext-download-as":
      if (!customElements.get(tagName)) {
        customElements.define(tagName, DownloadAs);
      }
      break;
    case "ontotext-dropdown":
      if (!customElements.get(tagName)) {
        defineCustomElement$3();
      }
      break;
    case "yasgui-tooltip":
      if (!customElements.get(tagName)) {
        defineCustomElement$2();
      }
      break;
  } });
}

const OntotextDownloadAs = DownloadAs;
const defineCustomElement = defineCustomElement$1;

export { OntotextDownloadAs, defineCustomElement };
