import { proxyCustomElement, HTMLElement, createEvent, h, Host } from '@stencil/core/internal/client';

const ontotextEditableTextFieldCss = ":host{display:flex;flex-direction:row;align-items:stretch}.editable-text-field-wrapper:hover{cursor:pointer}.editable-text-field-wrapper{display:flex;align-items:center}.editable-text-field-wrapper .edit-mode-container{display:flex;justify-content:space-between}.editable-text-field-wrapper .editable-text-field{outline-color:#00000059;border:1px solid #00000059;padding:0}.editable-text-field-wrapper .save-btn,.editable-text-field-wrapper .cancel-btn{border:none;outline:none;margin-left:6px}.editable-text-field-wrapper .save-btn{color:white;background-color:#e84e0f}.editable-text-field-wrapper .save-btn:hover{background-color:#d0460d}.editable-text-field-wrapper .cancel-btn:hover,.editable-text-field-wrapper .save-btn:hover{cursor:pointer}.editable-text-field-wrapper .cancel-btn:hover .cancel-btn-label,.editable-text-field-wrapper .save-btn:hover .save-btn-label{transform:scale(1.2);transition:transform 0.15s ease-out}.editable-text-field-wrapper .preview-value{padding-top:1px;max-width:200px;white-space:nowrap;overflow:hidden;text-overflow:ellipsis}";

const OntotextEditableTextField$1 = /*@__PURE__*/ proxyCustomElement(class extends HTMLElement {
  constructor() {
    super();
    this.__registerHost();
    this.valueChanged = createEvent(this, "valueChanged", 7);
    this.componentModeChanged = createEvent(this, "componentModeChanged", 7);
    /**
     * There is an issue when the component is opened programmatically, for instance, when it is opened from a context menu. In such cases,
     * the handler {@link OntotextEditableTextField#handleClickOutside} checks if the event is outside the component and takes an action.
     * This action is normally executed when the component is open and the user clicks outside the component.
     * This parameter is used to control when the first click event should be skipped.
     */
    this.skipFirstClickOutside = true;
    this.value = undefined;
    this.edit = false;
    this.translationService = undefined;
  }
  /**
   * Handler for changing view mode of component. When this happened a componentModeChanged even will be fired.
   *
   * @param edit - the new view mode.
   */
  handleEditModeChange(edit) {
    this.edit = edit;
    this.editedValue = this.value;
    this.componentModeChanged.emit(this.edit);
  }
  /**
   * Click handler. Saves {@link OntotextEditableTextField#value} if the click is outside component and component is in edit mode.
   */
  handleClickOutside(event) {
    // Nothing to do if the component is in preview mode or the component is not opened from a double click on host element.
    if (!this.edit || this.skipFirstClickOutside) {
      this.skipFirstClickOutside = false;
      return;
    }
    const clickedElement = event.target;
    // Check if the clicked element is outside the component
    if (!this.hostElement.contains(clickedElement) && this.inputElement && !this.inputElement.contains(clickedElement)) {
      this.save();
      this.cancel();
    }
  }
  keydownListener(ev) {
    if (!this.edit) {
      return;
    }
    if ('Enter' === ev.key) {
      this.save();
    }
    else if ('Escape' === ev.key) {
      this.cancel();
    }
  }
  /**
   * Initializes the field that holds edited value when component is loaded.
   */
  componentDidLoad() {
    this.editedValue = this.value;
  }
  /**
   * Sets the input element on focus if element is on edit mode when component is updated.
   */
  componentDidUpdate() {
    if (this.edit && this.inputElement) {
      this.inputElement.focus();
      this.inputElement.select();
    }
  }
  /**
   * Saves changed value of the text component for eventual future saving.
   */
  handleValueChanged(event) {
    this.editedValue = event.target.value;
  }
  /**
   * Switches component to edit mode.
   */
  openEditMode() {
    this.edit = true;
    this.editedValue = this.value;
    this.skipFirstClickOutside = true;
  }
  /**
   * Saves the value of text field and emits "valueChanged" event with the new value.
   */
  save() {
    const isValueChanged = this.value !== this.editedValue;
    this.value = this.editedValue;
    this.edit = false;
    if (isValueChanged) {
      this.valueChanged.emit(this.value);
    }
  }
  /**
   * Switches the component in preview mode.
   */
  cancel() {
    this.edit = false;
    this.editedValue = this.value;
  }
  render() {
    return (h(Host, { onDblClick: this.openEditMode, class: 'editable-text-field-wrapper' }, !this.edit && h("div", { class: 'preview-value' }, this.value), this.edit && (h("div", { class: 'edit-mode-container' }, h("input", { class: 'editable-text-field', type: "text", value: this.editedValue, onInput: (event) => this.handleValueChanged(event), ref: (el) => (this.inputElement = el) }), h("button", { onClick: () => this.save(), class: 'save-btn', title: (this.translationService ? this.translationService.translate('yasqe.tab_list.tab_rename.save.btn.label') : '') }, h("span", { class: 'save-btn-label icon-tick' })), h("button", { onClick: () => this.cancel(), class: 'cancel-btn', title: (this.translationService ? this.translationService.translate('yasqe.tab_list.tab_rename.cancel.btn.label') : '') }, h("span", { class: 'cancel-btn-label icon-close' }))))));
  }
  get hostElement() { return this; }
  static get watchers() { return {
    "edit": ["handleEditModeChange"]
  }; }
  static get style() { return ontotextEditableTextFieldCss; }
}, [0, "ontotext-editable-text-field", {
    "value": [1025],
    "edit": [1028],
    "translationService": [16]
  }, [[8, "click", "handleClickOutside"], [4, "keydown", "keydownListener"]]]);
function defineCustomElement$1() {
  if (typeof customElements === "undefined") {
    return;
  }
  const components = ["ontotext-editable-text-field"];
  components.forEach(tagName => { switch (tagName) {
    case "ontotext-editable-text-field":
      if (!customElements.get(tagName)) {
        customElements.define(tagName, OntotextEditableTextField$1);
      }
      break;
  } });
}

const OntotextEditableTextField = OntotextEditableTextField$1;
const defineCustomElement = defineCustomElement$1;

export { OntotextEditableTextField, defineCustomElement };
