import { proxyCustomElement, HTMLElement, createEvent, h, Host } from '@stencil/core/internal/client';
import { T as TranslationService } from './translation.service.js';
import { S as SaveQueryData, U as UpdateQueryData } from './saved-query-configuration.js';
import { H as HtmlUtil } from './html-util.js';
import { d as defineCustomElement$1 } from './ontotext-tooltip-web-component.js';

const saveQueryDialogCss = "@font-face{font-family:\"icomoon\";src:url(\"../css/fonts/icons.eot?z4jeba\");src:url(\"../css/fonts/icons.eot?z4jeba#iefix\") format(\"embedded-opentype\"), url(\"../css/fonts/icons.ttf?z4jeba\") format(\"truetype\"), url(\"../css/fonts/icons.woff?z4jeba\") format(\"woff\"), url(\"../css/fonts/icons.svg?z4jeba#icons\") format(\"svg\");font-weight:normal;font-style:normal}.red{color:#e84e0f}.hidden{display:none !important}.scroll-hidden{overflow:hidden}[class^=icon-],[class*=\" icon-\"],.icon-any{font-family:\"icomoon\", sans-serif !important;speak:none;font-style:normal;font-weight:normal;font-variant:normal;text-transform:none;line-height:1;vertical-align:middle;display:inline-block;-webkit-font-smoothing:antialiased;-moz-osx-font-smoothing:grayscale}.icon-lg{font-size:1.2em}.icon-arrow-up-off:before{content:\"\\e948\"}.icon-collapse:before{content:\"\\e949\"}.icon-eye-off:before{content:\"\\e94a\"}.icon-expand:before{content:\"\\e94c\"}.icon-focus:before{content:\"\\e94d\"}.icon-rotate-left:before{content:\"\\e94e\"}.icon-rotate-right:before{content:\"\\e94f\"}.icon-info-alt:before{content:\"\\e950\"}.icon-facebook:before{content:\"\\e942\"}.icon-google-plus:before{content:\"\\e943\"}.icon-google:before{content:\"\\e944\"}.icon-linkedin:before{content:\"\\e945\"}.icon-twitter:before{content:\"\\e946\"}.icon-youtube:before{content:\"\\e947\"}.icon-play:before{content:\"\\e941\"}.icon-email:before{content:\"\\e93e\"}.icon-same-as-on:before{content:\"\\e93f\"}.icon-same-as-off:before{content:\"\\e940\"}.icon-repo-contour1:before{content:\"\\e906\"}.icon-repo-contour2:before{content:\"\\e90b\"}.icon-repo-contour3:before{content:\"\\e910\"}.icon-repo-master-ro-mute:before{content:\"\\e913\"}.icon-repo-free:before{content:\"\\e936\"}.icon-repo-master-mute:before{content:\"\\e937\"}.icon-repo-master-ro:before{content:\"\\e938\"}.icon-repo-master:before{content:\"\\e939\"}.icon-repo-se:before{content:\"\\e93a\"}.icon-repo-system:before{content:\"\\e93b\"}.icon-repo-worker:before{content:\"\\e93c\"}.icon-repo:before{content:\"\\e93d\"}.icon-copy:before{content:\"\\e934\"}.icon-eye:before{content:\"\\e935\"}.icon-connection-off:before{content:\"\\e931\"}.icon-connection-on:before{content:\"\\e932\"}.icon-key:before{content:\"\\e933\"}.icon-comment:before{content:\"\\e930\"}.icon-arrow-down:before{content:\"\\e900\"}.icon-arrow-left:before{content:\"\\e901\"}.icon-arrow-right:before{content:\"\\e902\"}.icon-arrow-up:before{content:\"\\e903\"}.icon-exchange:before{content:\"\\e904\"}.icon-columns:before{content:\"\\e905\"}.icon-inferred-off:before{content:\"\\e907\"}.icon-inferred-on:before{content:\"\\e908\"}.icon-save:before{content:\"\\e909\"}.icon-tag:before{content:\"\\e90a\"}.icon-file:before{content:\"\\e90c\"}.icon-folder:before{content:\"\\e90d\"}.icon-heartbeat:before{content:\"\\e90e\"}.icon-pin:before{content:\"\\e90f\"}.icon-zoom-in:before{content:\"\\e911\"}.icon-zoom-out:before{content:\"\\e912\"}.icon-check:before{content:\"\\e914\"}.icon-download:before{content:\"\\e915\"}.icon-external:before{content:\"\\e916\"}.icon-lock:before{content:\"\\e917\"}.icon-search:before{content:\"\\e918\"}.icon-upload:before{content:\"\\e919\"}.icon-caret-left:before{content:\"\\e91a\"}.icon-caret-right:before{content:\"\\e91b\"}.icon-caret-up:before{content:\"\\e91c\"}.icon-caret-up-after:after{content:\"\\e91c\"}.icon-minus:before{content:\"\\e91d\"}.icon-reload:before{content:\"\\e91e\"}.icon-trash:before{content:\"\\e91f\"}.icon-warning:before{content:\"\\e920\"}.icon-caret-down:before{content:\"\\e921\"}.icon-caret-down-after:after{content:\"\\e921\"}.icon-close:before{content:\"\\e922\"}.icon-edit:before{content:\"\\e923\"}.icon-info:before{content:\"\\e924\"}.icon-link:before{content:\"\\e925\"}.icon-more:before{content:\"\\e926\"}.icon-plus:before{content:\"\\e927\"}.icon-data:before{content:\"\\e928\"}.icon-help:before{content:\"\\e929\"}.icon-monitoring:before{content:\"\\e92a\"}.icon-settings:before{content:\"\\e92b\"}.icon-sparql:before{content:\"\\e92c\"}.icon-user-alt:before{content:\"\\e92d\"}.icon-export-alt:before{content:\"\\e92e\"}.icon-import:before{content:\"\\e92f\"}.icon-tick:before{content:\"\\e956\"}.icon-repo-ontop-alt:before{content:\"\\e958\"}.icon-repo-fedx-alt:before{content:\"\\e959\"}.icon-repo-graphdb-alt:before{content:\"\\e95a\"}.icon-export:before{content:\"\\e95b\"}.icon-readonly:before{content:\"\\e95c\"}.icon-repo-fedx:before{content:\"\\e95d\"}.icon-repo-graphdb:before{content:\"\\e95e\"}.icon-repo-ontop:before{content:\"\\e95f\"}.icon-repo-unknown:before{content:\"\\e960\"}.icon-translation:before{content:\"\\e961\"}.icon-user:before{content:\"\\e962\"}.icon-follower:before{content:\"\\e962\"}.alert{border-radius:0;border:1px solid transparent;position:relative;padding:1em}.alert-warning,.alert-info,.alert-help,.alert-danger,.alert-success{color:#000000A8}.alert-warning{background-color:#f9e6c0}.alert-info{background-color:#cfefec}.alert-help{background-color:#e7f7f5}.alert-success{background-color:#dff0d8}.alert-danger{background-color:#fbdbd5}.alert-info,.alert-warning,.alert-help,.alert-danger,.alert-success{padding-left:3em}.alert-info:before,.alert-warning:before,.alert-help:before,.alert-danger:before,.alert-success:before{font-family:\"icomoon\", sans-serif !important;font-size:1.6em;vertical-align:middle;line-height:1;position:absolute;left:0.6em;top:0.6em;color:#00000080}.alert-info:before{content:\"\\e924\"}.alert-warning:before{content:\"\\e930\"}.alert-help:before{content:\"\\e929\"}.alert-danger:before{content:\"\\e920\"}.alert-success:before{content:\"\\e914\"}.no-icon{padding-left:1em}.no-icon:before{display:none}.alert .alert{background-color:transparent}.icon-rotate-quarter:before{display:inline-block;-webkit-transform:rotate(270deg);-ms-transform:rotate(270deg);transform:rotate(270deg)}:host{display:block}.dialog-overlay{position:fixed;top:0;bottom:0;left:0;right:0;display:flex;align-items:center;justify-content:center;z-index:9998;margin-left:-10px;background-color:rgba(0, 0, 0, 0.5);font-family:\"Roboto\", \"Helvetica Neue\", Arial, sans-serif;font-weight:300;color:#373a3c}.dialog{z-index:1001;width:600px;max-width:600px;background-color:#fff;box-shadow:0 5px 15px rgba(0, 0, 0, 0.5);font-family:inherit;font-weight:inherit}.dialog .dialog-header{display:flex;justify-content:space-between;padding:15px;border-bottom:1px solid #e5e5e5;font-size:20px}.dialog .dialog-header .dialog-title{margin:0.5rem 0;font-weight:400}.dialog .dialog-header .close-button{background-color:#fff;border:none;outline:none;cursor:pointer;transition:all 0.15s ease-out}.dialog .dialog-header .close-button:hover,.dialog .dialog-header .close-button:focus{font-weight:bold}.dialog .dialog-body{padding:15px}.dialog .dialog-body .save-query-form{display:flex;flex-direction:column;gap:1rem;align-items:stretch}.dialog .dialog-body .form-field{display:flex;flex-direction:column;justify-content:space-between}.dialog .dialog-body .form-field input[type=text],.dialog .dialog-body .form-field textarea{padding:0.5rem 0.75rem;border:1px solid rgba(0, 0, 0, 0.15);font-size:1rem;color:#55595c}.dialog .dialog-body .form-field input[type=text]:focus,.dialog .dialog-body .form-field textarea:focus{border-color:rgba(0, 54, 99, 0.5);outline:none}.dialog .dialog-body .form-field input[type=text].invalid{border-color:#fa787e}.dialog .dialog-body .form-field textarea{resize:vertical}.dialog .dialog-body .form-field textarea.invalid{border-color:#fa787e}.dialog .dialog-body .form-field.is-public-field .yasgui-tooltip{width:fit-content}.dialog .dialog-body .form-field.is-public-field input{margin-right:5px}.dialog .dialog-body .form-field.is-public-field label{margin:0}.dialog .dialog-body .form-field.is-public-field label:hover{cursor:pointer}.dialog .dialog-body .alert{margin-top:5px}.dialog .dialog-footer{display:flex;justify-content:flex-end;padding:15px;border-top:1px solid #e5e5e5}.dialog .dialog-footer button{display:inline-block;font-weight:400;line-height:1.25;text-align:center;white-space:nowrap;vertical-align:middle;cursor:pointer;user-select:none;border:1px solid transparent;outline:none;padding:0.5rem 1rem;font-size:1rem;border-radius:0;transition:all 0.15s ease-out}.dialog .dialog-footer .ok-button{background-color:#e84e0f;border-color:#e84e0f;color:#fff}.dialog .dialog-footer .ok-button:hover,.dialog .dialog-footer .ok-button:focus{background-color:#d0460d;border-color:#d0460d}.dialog .dialog-footer .cancel-button{color:#003663;margin-right:10px}.dialog .dialog-footer .cancel-button:hover,.dialog .dialog-footer .cancel-button:focus{background-color:#d4d4d4;border-color:#d4d4d4}";

const SaveQueryDialog = /*@__PURE__*/ proxyCustomElement(class extends HTMLElement {
  constructor() {
    super();
    this.__registerHost();
    this.internalSaveQueryDialogClosedEvent = createEvent(this, "internalSaveQueryDialogClosedEvent", 7);
    this.internalSaveQueryEvent = createEvent(this, "internalSaveQueryEvent", 7);
    this.internalUpdateQueryEvent = createEvent(this, "internalUpdateQueryEvent", 7);
    this.serviceFactory = undefined;
    this.data = undefined;
    this.queryName = '';
    this.query = '';
    this.isPublic = false;
    this.isNew = false;
    this.isSaveAllowed = false;
  }
  /**
   * Handles the Escape key keydown event and closes the dialog.
   * @param ev The keyboard event.
   */
  keydownListener(ev) {
    if (ev.key === 'Escape') {
      this.internalSaveQueryDialogClosedEvent.emit();
    }
  }
  componentWillLoad() {
    // TranslationService is injected here because the service factory is not available
    // in the constructor.
    this.translationService = this.serviceFactory.get(TranslationService);
    if (this.data) {
      this.queryName = this.data.queryName || this.queryName;
      this.query = this.data.query || this.query;
      this.isPublic = this.data.isPublic !== undefined ? this.data.isPublic : this.isPublic;
      this.isNew = this.data.isNew !== undefined ? this.data.isNew : this.isNew;
      this.resolveIsSaveAllowed();
    }
  }
  componentDidLoad() {
    this.documentOverflow = HtmlUtil.hideDocumentBodyOverflow();
    this.hostElement.addEventListener('keydown', this.preventLeavingDialog.bind(this));
    this.cancelButton.focus();
  }
  disconnectedCallback() {
    HtmlUtil.setDocumentBodyOverflow(this.documentOverflow);
    this.hostElement.removeEventListener('keydown', this.preventLeavingDialog.bind(this));
  }
  onClose(evt) {
    const target = evt.target;
    evt.stopPropagation();
    const isOverlay = target.classList.contains('dialog-overlay');
    const isCloseButton = target.classList.contains('close-button');
    const isCancelButton = target.classList.contains('cancel-button');
    if (isOverlay || isCloseButton || isCancelButton) {
      this.internalSaveQueryDialogClosedEvent.emit();
    }
  }
  onCreate(evt) {
    evt.stopPropagation();
    const queryName = this.queryName;
    const query = this.query;
    const isPublic = this.isPublic;
    if (this.isNew) {
      this.internalSaveQueryEvent.emit(new SaveQueryData(queryName, query, isPublic));
    }
    else {
      this.internalUpdateQueryEvent.emit(new UpdateQueryData(queryName, query, isPublic));
    }
  }
  handleQueryNameChange(event) {
    this.queryName = event.target.value;
    this.resolveIsSaveAllowed();
  }
  handleQueryChange(event) {
    this.query = event.target.value;
    this.resolveIsSaveAllowed();
  }
  handleIsPublicChange(event) {
    this.isPublic = event.target.checked;
  }
  preventLeavingDialog(ev) {
    HtmlUtil.preventLeavingDialog(this.hostElement, ev);
  }
  resolveIsSaveAllowed() {
    this.isSaveAllowed = !!(this.queryName.trim().length && this.query.trim().length);
  }
  getErrorMessages() {
    const errorMessages = [];
    if (this.hasMissingQueryName()) {
      errorMessages.push(this.translationService.translate('yasqe.actions.save_query.dialog.query_name.empty_error'));
    }
    if (this.hasMissingQuery()) {
      errorMessages.push(this.translationService.translate('yasqe.actions.save_query.dialog.query.empty_error'));
    }
    if (this.data.messages) {
      errorMessages.push(...this.data.messages);
    }
    return errorMessages;
  }
  hasMissingQueryName() {
    return !this.queryName.trim().length;
  }
  hasMissingQuery() {
    return !this.query.trim().length;
  }
  hasMissingFields() {
    return this.hasMissingQuery() || this.hasMissingQueryName();
  }
  showErrorMessage() {
    var _a;
    return this.hasMissingFields() || ((_a = this.data.messages) === null || _a === void 0 ? void 0 : _a.length) > 0;
  }
  render() {
    return (h(Host, { tabindex: '-1' }, h("div", { class: "dialog-overlay", onClick: (evt) => this.onClose(evt) }, h("div", { class: "dialog" }, h("div", { class: "dialog-header" }, h("h3", { class: "dialog-title" }, this.translationService.translate('yasqe.actions.save_query.dialog.title')), h("button", { class: "close-button icon-close", onClick: (evt) => this.onClose(evt) })), h("div", { class: "dialog-body" }, h("div", { class: "save-query-form" }, h("div", { class: "form-field query-name-field" }, h("input", { type: "text", name: "queryName", id: "queryName", required: true, value: this.queryName, class: !this.queryName.trim().length ? 'invalid' : '', placeholder: this.translationService.translate('yasqe.actions.save_query.dialog.query_name.label'), onInput: (evt) => this.handleQueryNameChange(evt) })), h("div", { class: "form-field is-public-field" }, h("yasgui-tooltip", { placement: "top", "data-tooltip": this.translationService.translate('yasqe.actions.save_query.dialog.public_query.tooltip') }, h("label", null, h("input", { type: "checkbox", name: "publicQuery", id: "publicQuery", checked: this.isPublic, onChange: (evt) => this.handleIsPublicChange(evt) }), this.translationService.translate('yasqe.actions.save_query.dialog.public_query.label')))), h("div", { class: "form-field query-field" }, h("textarea", { name: "query", id: "query", required: true, rows: 8, class: !this.query.trim().length ? 'invalid' : '', placeholder: this.translationService.translate('yasqe.actions.save_query.dialog.query.label'), value: this.query, onInput: (evt) => this.handleQueryChange(evt) })), this.showErrorMessage() && h(Alert, { messages: this.getErrorMessages() }, "\u00A0"))), h("div", { class: "dialog-footer" }, h("button", { class: "cancel-button", onClick: (evt) => this.onClose(evt), ref: (el) => (this.cancelButton = el) }, this.translationService.translate('yasqe.actions.save_query.dialog.cancel.button')), h("button", { class: "ok-button", disabled: !this.isSaveAllowed, onClick: (evt) => this.onCreate(evt) }, this.translationService.translate('yasqe.actions.save_query.dialog.create.button')))))));
  }
  get hostElement() { return this; }
  static get style() { return saveQueryDialogCss; }
}, [0, "save-query-dialog", {
    "serviceFactory": [16],
    "data": [16],
    "queryName": [32],
    "query": [32],
    "isPublic": [32],
    "isNew": [32],
    "isSaveAllowed": [32]
  }, [[8, "keydown", "keydownListener"]]]);
const Alert = ({ messages }) => (h("div", { class: "alert alert-danger" }, messages.map((message) => (h("div", { class: "error-message" }, message)))));
function defineCustomElement() {
  if (typeof customElements === "undefined") {
    return;
  }
  const components = ["save-query-dialog", "yasgui-tooltip"];
  components.forEach(tagName => { switch (tagName) {
    case "save-query-dialog":
      if (!customElements.get(tagName)) {
        customElements.define(tagName, SaveQueryDialog);
      }
      break;
    case "yasgui-tooltip":
      if (!customElements.get(tagName)) {
        defineCustomElement$1();
      }
      break;
  } });
}

export { SaveQueryDialog as S, defineCustomElement as d };
