import { proxyCustomElement, HTMLElement, createEvent, h, Host } from '@stencil/core/internal/client';
import { U as UpdateQueryData, D as DeleteQueryData } from './saved-query-configuration.js';
import { T as TranslationService } from './translation.service.js';

const savedQueriesPopupCss = ":host{display:block}.saved-queries-container{position:absolute;z-index:1015;border:1px solid #ccc;font-family:\"Roboto\", \"Helvetica Neue\", Arial, sans-serif;font-weight:300;background-color:#fff}.saved-queries-container .saved-queries-popup{max-height:250px;width:300px;overflow-y:scroll;box-shadow:0 4px 8px rgba(0, 0, 0, 0.3)}.saved-queries-container .saved-queries-popup ul{padding:15px;margin:0}.saved-queries-container .saved-queries-popup ul .saved-query{position:relative;display:flex;justify-content:space-between;padding:5px 0;list-style-type:none}.saved-queries-container .saved-queries-popup ul .saved-query .saved-query-link{white-space:nowrap;overflow:hidden;text-overflow:ellipsis}.saved-queries-container .saved-queries-popup ul .saved-query:hover .saved-query-actions{display:block}.saved-queries-container .saved-queries-popup ul .saved-query a{flex-grow:2;text-decoration:none;cursor:pointer;color:#003663}.saved-queries-container .saved-queries-popup ul .saved-query a:hover{text-decoration:underline}.saved-queries-container .saved-queries-popup ul .saved-query .saved-query-actions{display:none;position:absolute;right:0}.saved-queries-container .saved-queries-popup ul .saved-query .saved-query-action{border:none;background-color:#fff;color:#e84e0f;outline:none;cursor:pointer;font-size:1em;transition:all 0.15s ease-out}.saved-queries-container .saved-queries-popup ul .saved-query .saved-query-action:hover{color:#d0460d;transform:scale(1.2)}.saved-queries-container .arrow{position:absolute;display:block;right:calc(-0.5rem - 1px);width:8px;height:16px;margin:0.3rem 0}.saved-queries-container .arrow::before,.saved-queries-container .arrow::after{position:absolute;display:block;content:\"\";border-color:transparent;border-style:solid}.saved-queries-container .arrow::before{right:0;border-width:0.5rem 0 0.5rem 0.5rem;border-left-color:rgba(0, 0, 0, 0.25)}.saved-queries-container .arrow::after{right:1px;border-width:0.5rem 0 0.5rem 0.5rem;border-left-color:#fff}";

const SavedQueriesPopup = /*@__PURE__*/ proxyCustomElement(class extends HTMLElement {
  constructor() {
    super();
    this.__registerHost();
    this.internalSaveQuerySelectedEvent = createEvent(this, "internalSaveQuerySelectedEvent", 7);
    this.internalEditSavedQueryEvent = createEvent(this, "internalEditSavedQueryEvent", 7);
    this.internalSavedQuerySelectedForDeleteEvent = createEvent(this, "internalSavedQuerySelectedForDeleteEvent", 7);
    this.internalSavedQuerySelectedForShareEvent = createEvent(this, "internalSavedQuerySelectedForShareEvent", 7);
    this.internalCloseSavedQueriesPopupEvent = createEvent(this, "internalCloseSavedQueriesPopupEvent", 7);
    this.config = undefined;
    this.serviceFactory = undefined;
  }
  onWindowResize(event) {
    const target = event.target;
    if (!target.closest('.saved-queries-container')) {
      this.internalCloseSavedQueriesPopupEvent.emit();
    }
  }
  /**
   * Handles the Escape key keydown event and closes the dialog.
   * @param ev The keyboard event.
   */
  keydownListener(ev) {
    if (ev.key === 'Escape') {
      this.internalCloseSavedQueriesPopupEvent.emit();
    }
  }
  onSelect(evt, selectedQuery) {
    evt.stopPropagation();
    this.internalSaveQuerySelectedEvent.emit(selectedQuery);
  }
  componentWillLoad() {
    // TranslationService is injected here because the service factory is not available
    // in the constructor.
    this.translationService = this.serviceFactory.get(TranslationService);
  }
  componentDidRender() {
    this.setPopupPosition();
  }
  onEdit(evt, selectedQuery) {
    evt.stopPropagation();
    this.internalEditSavedQueryEvent.emit(new UpdateQueryData(selectedQuery.queryName, selectedQuery.query, selectedQuery.isPublic, false));
  }
  onDelete(evt, selectedQuery) {
    evt.stopPropagation();
    this.internalSavedQuerySelectedForDeleteEvent.emit(new DeleteQueryData(selectedQuery.queryName, selectedQuery.query, selectedQuery.isPublic));
  }
  onShare(evt, selectedQuery) {
    evt.stopPropagation();
    this.internalSavedQuerySelectedForShareEvent.emit(new DeleteQueryData(selectedQuery.queryName, selectedQuery.query, selectedQuery.isPublic));
  }
  setPopupPosition() {
    const panelRect = this.hostElement.getBoundingClientRect();
    const buttonRect = this.config.popupTarget.getBoundingClientRect();
    const isFullScreen = this.hostElement.closest('ontotext-yasgui').querySelector('.yasqe').classList.contains('yasqe-fullscreen');
    const arrowEl = this.hostElement.querySelector('.arrow');
    if (isFullScreen) {
      this.hostElement.style.top = '13px';
      this.hostElement.style.left = (buttonRect.left - panelRect.width - 10) + 'px';
      arrowEl.style.top = '40px';
    }
    else {
      this.hostElement.style.top = ((buttonRect.top + buttonRect.height / 2) - panelRect.height / 2) + 'px';
      this.hostElement.style.left = (buttonRect.left - panelRect.width - 10) + 'px';
      arrowEl.style.top = panelRect.height / 2 - 16 + 'px';
    }
  }
  render() {
    return (h(Host, { class: "saved-queries-container" }, h("div", { class: "arrow" }), h("div", { class: "saved-queries-popup" }, h("ul", null, this.config.savedQueriesList.map((savedQuery) => (h("li", { class: "saved-query" }, h("a", { class: "saved-query-link", onClick: (evt) => this.onSelect(evt, savedQuery) }, savedQuery.queryName), h("span", { class: "saved-query-actions" }, h("button", { class: "saved-query-action edit-saved-query icon-edit", title: this.translationService.translate('yasqe.actions.saved_query_dialog.edit.button.tooltip'), onClick: (evt) => this.onEdit(evt, savedQuery) }), h("button", { class: "saved-query-action delete-saved-query icon-trash", title: this.translationService.translate('yasqe.actions.saved_query_dialog.delete.button.tooltip'), onClick: (evt) => this.onDelete(evt, savedQuery) }), h("button", { class: "saved-query-action share-saved-query icon-link", title: this.translationService.translate('yasqe.actions.saved_query_dialog.share.button.tooltip'), onClick: (evt) => this.onShare(evt, savedQuery) })))))))));
  }
  get hostElement() { return this; }
  static get style() { return savedQueriesPopupCss; }
}, [0, "saved-queries-popup", {
    "config": [16],
    "serviceFactory": [16]
  }, [[8, "click", "onWindowResize"], [8, "keydown", "keydownListener"]]]);
function defineCustomElement() {
  if (typeof customElements === "undefined") {
    return;
  }
  const components = ["saved-queries-popup"];
  components.forEach(tagName => { switch (tagName) {
    case "saved-queries-popup":
      if (!customElements.get(tagName)) {
        customElements.define(tagName, SavedQueriesPopup);
      }
      break;
  } });
}

export { SavedQueriesPopup as S, defineCustomElement as d };
