import { proxyCustomElement, HTMLElement, createEvent, h } from '@stencil/core/internal/client';
import { d as defineCustomElement$2 } from './copy-link-dialog2.js';
import { d as defineCustomElement$1 } from './ontotext-dialog-web-component2.js';

const shareQueryDialogCss = "";

const ShareQueryDialog = /*@__PURE__*/ proxyCustomElement(class extends HTMLElement {
  constructor() {
    super();
    this.__registerHost();
    this.internalShareQueryDialogClosedEvent = createEvent(this, "internalShareQueryDialogClosedEvent", 7);
    this.internalQueryShareLinkCopiedEvent = createEvent(this, "internalQueryShareLinkCopiedEvent", 7);
    this.config = undefined;
    this.serviceFactory = undefined;
  }
  onDialogClosed() {
    this.internalShareQueryDialogClosedEvent.emit();
  }
  onLinkCopied() {
    this.internalQueryShareLinkCopiedEvent.emit();
  }
  render() {
    return (h("copy-link-dialog", { config: { copyLink: this.config.shareQueryLink }, serviceFactory: this.serviceFactory, classes: "share-saved-query-dialog", copyLinkEventsObserver: this }));
  }
  static get style() { return shareQueryDialogCss; }
}, [0, "share-query-dialog", {
    "config": [16],
    "serviceFactory": [16]
  }]);
function defineCustomElement() {
  if (typeof customElements === "undefined") {
    return;
  }
  const components = ["share-query-dialog", "copy-link-dialog", "ontotext-dialog-web-component"];
  components.forEach(tagName => { switch (tagName) {
    case "share-query-dialog":
      if (!customElements.get(tagName)) {
        customElements.define(tagName, ShareQueryDialog);
      }
      break;
    case "copy-link-dialog":
      if (!customElements.get(tagName)) {
        defineCustomElement$2();
      }
      break;
    case "ontotext-dialog-web-component":
      if (!customElements.get(tagName)) {
        defineCustomElement$1();
      }
      break;
  } });
}

export { ShareQueryDialog as S, defineCustomElement as d };
