import { r as registerInstance, h, H as Host, g as getElement } from './index-54a11d4e.js';
import { E as EventService } from './event-service-e1a9482c.js';
import { I as InternalEventType } from './internal-event-types-35c83cea.js';
import './internal-download-as-event-6d7e2160.js';
import './internal-dropdown-value-selected-event-c9804361.js';

const copyResourceLinkButtonCss = ".copy-resource-link-button a.icon-link:hover{text-decoration:none}";

const CopyResourceLinkButton = class {
  constructor(hostRef) {
    registerInstance(this, hostRef);
    this.uri = undefined;
    this.classes = undefined;
  }
  onButtonClick() {
    EventService.emitFromInnerElement(this.hostElement, InternalEventType.INTERNAL_SHOW_RESOURCE_COPY_LINK_DIALOG_EVENT, { copyLink: this.uri });
  }
  render() {
    const classList = `copy-resource-link-button ${this.classes || ''}`;
    return (h(Host, { class: classList }, h("a", { class: "icon-link", href: "#", onClick: () => this.onButtonClick() })));
  }
  get hostElement() { return getElement(this); }
};
CopyResourceLinkButton.style = copyResourceLinkButtonCss;

export { CopyResourceLinkButton as copy_resource_link_button };
