import { r as registerInstance, c as createEvent, h } from './index-54a11d4e.js';
import { I as InternalDownloadAsEvent } from './internal-download-as-event-6d7e2160.js';
import './internal-event-types-35c83cea.js';

const downloadAsCss = "";

const DownloadAs = class {
  constructor(hostRef) {
    registerInstance(this, hostRef);
    this.downloadAs = createEvent(this, "internalDownloadAsEvent", 7);
    this.translationService = undefined;
    this.nameLabelKey = undefined;
    this.tooltipLabelKey = undefined;
    this.items = undefined;
    this.pluginName = undefined;
    this.query = undefined;
    this.infer = undefined;
    this.sameAs = undefined;
  }
  onInternalDropdownValueSelected(event) {
    this.downloadAs.emit(new InternalDownloadAsEvent(event.detail.payload.value, this.pluginName, this.query, this.infer, this.sameAs));
  }
  render() {
    return (h("ontotext-dropdown", { class: 'ontotext-download-as', onValueChanged: ev => this.onInternalDropdownValueSelected(ev), translationService: this.translationService, tooltipLabelKey: this.tooltipLabelKey, nameLabelKey: this.nameLabelKey ? this.nameLabelKey : DownloadAs.DEFAULT_NAME_LABEL, iconClass: 'icon-download', items: this.items }));
  }
};
DownloadAs.DEFAULT_NAME_LABEL = 'yasr.plugin_control.download_results.btn.label';
DownloadAs.style = downloadAsCss;

export { DownloadAs as ontotext_download_as };
