import { r as registerInstance, c as createEvent, h } from './index-54a11d4e.js';
import { I as InternalDropdownValueSelectedEvent } from './internal-dropdown-value-selected-event-c9804361.js';
import './internal-event-types-35c83cea.js';

const dropdownCss = ".ontotext-dropdown .ontotext-dropdown-button{font-size:16px;font-weight:400;padding:5px 16px;line-height:1.25;border:none;outline:none;color:#FFFFFF;background-color:#e84e0f}.ontotext-dropdown .ontotext-dropdown-menu{position:absolute;margin:0;padding:0;z-index:1000}.ontotext-dropdown .ontotext-dropdown-menu-item{display:block;text-decoration:none;font-size:1rem;font-weight:400;padding:0.5em 1.2em;color:#FFFFFF;background-color:#e84e0f}.ontotext-dropdown .ontotext-dropdown-menu-item:hover{text-decoration:none;background-color:#d0460d;color:#ffffff}.ontotext-dropdown .ontotext-dropdown-icon:before{padding-right:5px}.ontotext-dropdown .ontotext-dropdown-button.icon-caret-down-after:after,.ontotext-dropdown .ontotext-dropdown-button.icon-caret-up-after:after{padding-left:10px;color:#00000059}.ontotext-dropdown .ontotext-dropdown-menu.closed{display:none}.ontotext-dropdown .ontotext-dropdown-button:hover{cursor:pointer}@media (max-width: 768px){.ontotext-dropdown .ontotext-dropdown-button:after{padding-left:0 !important}.ontotext-dropdown .button-name{display:none}}";

const Dropdown = class {
  constructor(hostRef) {
    registerInstance(this, hostRef);
    this.valueChanged = createEvent(this, "valueChanged", 7);
    this.open = false;
    this.showTooltip = false;
    this.translationService = undefined;
    this.nameLabelKey = undefined;
    this.tooltipLabelKey = undefined;
    this.items = undefined;
    this.iconClass = '';
  }
  /**
   * Handles the Escape key keydown event and closes the dialog.
   * @param ev The keyboard event.
   */
  keydownListener(ev) {
    if (ev.key === 'Escape') {
      this.closeMenu();
    }
  }
  /**
   * Handles the mouse click events and closes the menu when target is outside the menu.
   * @param ev The mouse event.
   */
  mouseClickListener(ev) {
    const target = ev.target;
    if (!target.closest('.ontotext-dropdown')) {
      this.closeMenu();
    }
  }
  render() {
    const showToolbar = this.tooltipLabelKey && window.innerWidth < 768;
    const dropdownButtonClass = `ontotext-dropdown-button ${this.open ? 'icon-caret-up-after' : ' icon-caret-down-after'}
    ${this.iconClass ? `ontotext-dropdown-icon ${this.iconClass}` : ''}`;
    return (h("yasgui-tooltip", { "data-tooltip": showToolbar ? this.translate(this.nameLabelKey) : '' }, h("div", { class: 'ontotext-dropdown' }, h("button", { class: dropdownButtonClass, onClick: () => this.toggleComponent() }, h("span", { class: 'button-name' }, this.translate(this.nameLabelKey))), h("div", { class: `ontotext-dropdown-menu ${this.open ? 'open' : 'closed'}` }, this.items && this.items.map(item => h("a", { href: "#", class: 'ontotext-dropdown-menu-item', onClick: () => this.onSelect(item.value) }, this.translate(item.labelKey)))))));
  }
  onSelect(value) {
    this.open = false;
    this.valueChanged.emit(new InternalDropdownValueSelectedEvent(value));
  }
  toggleComponent() {
    this.open = !this.open;
  }
  translate(labelKey) {
    if (this.translationService) {
      return this.translationService.translate(labelKey);
    }
    return '';
  }
  closeMenu() {
    this.open = false;
  }
};
Dropdown.style = dropdownCss;

export { Dropdown as ontotext_dropdown };
