import { r as registerInstance, c as createEvent, h, H as Host } from './index-54a11d4e.js';

class Page {
  constructor(_pageSize, _pageNumber) {
    this._pageSize = _pageSize;
    this._pageNumber = _pageNumber;
  }
  get pageSize() {
    return this._pageSize;
  }
  get pageNumber() {
    return this._pageNumber;
  }
}

const paginationCss = ".ontotext-pagination .page-selectors{height:100%;display:flex;justify-content:space-around;align-items:center;min-width:100px}.ontotext-pagination .page-selector{color:#0060b0;padding:2px 5px;background-color:#FFF;border:none;cursor:pointer}.ontotext-pagination .page-selector:disabled{cursor:unset}.ontotext-pagination .previous-button:disabled,.ontotext-pagination .next-button:disabled{opacity:0.4}.ontotext-pagination .selected-page{background-color:#e84e0f;color:#FFFFFF}";

const Pagination = class {
  constructor(hostRef) {
    registerInstance(this, hostRef);
    this.pageSelected = createEvent(this, "pageSelected", 7);
    this.VISIBLE_PAGES_COUNT = 5;
    this.PAGES_COUNT_AROUND_CURRENT = 2;
    this.pageNumber = 1;
    this.pageSize = 10;
    this.totalElements = 0;
    this.pageElements = undefined;
    this.hasMorePages = undefined;
    this.selectPage(this.pageNumber);
  }
  getShownPageNumbers() {
    const lastShownPage = this.fetchLastShownPage();
    const firstShownPage = this.fetchFirstShownPage(lastShownPage);
    const pages = [];
    for (let index = firstShownPage; index <= lastShownPage; index++) {
      pages.push(index);
    }
    return pages;
  }
  fetchLastShownPage() {
    const currentPageNumber = this.pageNumber;
    let lastShownPage = currentPageNumber;
    const pagesAfterCurrent = currentPageNumber <= 3 ? this.VISIBLE_PAGES_COUNT - currentPageNumber : this.PAGES_COUNT_AROUND_CURRENT;
    for (let pageNumber = 0; pageNumber < pagesAfterCurrent; pageNumber++) {
      if ((currentPageNumber + pageNumber) * this.pageSize < this.totalElements) {
        lastShownPage += 1;
      }
    }
    return lastShownPage;
  }
  fetchFirstShownPage(lastShownPage) {
    const firstPage = lastShownPage - this.VISIBLE_PAGES_COUNT + 1;
    return firstPage < 1 ? 1 : firstPage;
  }
  previousButtonDisabled() {
    return this.pageNumber < this.PAGES_COUNT_AROUND_CURRENT;
  }
  nextButtonDisabled() {
    if (this.totalElements && this.totalElements >= 0) {
      return this.pageNumber * this.pageSize >= this.totalElements;
    }
    return !this.hasMorePages;
  }
  nextPage() {
    this.pageSelected.emit(new Page(this.pageSize, this.pageNumber + 1));
  }
  previousPage() {
    this.pageSelected.emit(new Page(this.pageSize, this.pageNumber - 1));
  }
  selectPage(pageNumber) {
    if (this.pageNumber !== pageNumber) {
      this.pageSelected.emit(new Page(this.pageSize, pageNumber));
    }
  }
  render() {
    return (h(Host, { class: "ontotext-pagination" }, h("div", { class: "page-selectors" }, h("button", { class: "page-selector previous-button", onClick: () => this.previousPage(), disabled: this.previousButtonDisabled() }, "\u2039"), this.getShownPageNumbers().map(pageNumber => {
      return h("button", { class: `page-button page-selector ${this.pageNumber === pageNumber ? 'selected-page' : ''}`, onClick: () => this.selectPage(pageNumber), disabled: this.pageNumber === pageNumber }, pageNumber);
    }), h("button", { class: "page-selector next-button", onClick: () => this.nextPage(), disabled: this.nextButtonDisabled() }, "\u203A"))));
  }
};
Pagination.style = paginationCss;

export { Pagination as ontotext_pagination };
