export type AlertBoxType = 'info' | 'warning' | 'help' | 'danger' | 'success';
/**
 * Implementation of dismissible alert box component which can be configured.
 */
export declare class AlertBox {
  /**
   * Defines the alert type which is represented by different color, background and icon.
   * Default is <code>"info"</code>.
   */
  type: AlertBoxType;
  /**
   * The message which should be displayed in the alert. If the message is not provided, then the
   * alert is not displayed.
   */
  message: string;
  /**
   * Configures if the icon in the alert should be displayed or not.
   * Default is <code>true</code>
   */
  noIcon: boolean;
  /**
     * Configures if the close button in the alert should be displayed or not.
     * Default is <code>false</code>
     */
  noButton: boolean;
  /**
   * Controls the visibility of the alert.
   * Default is <code>true</code>
   */
  isVisible: boolean;
  onClose(evt: MouseEvent): void;
  render(): any;
}
