import { EventEmitter } from '../../stencil-public-runtime';
import { TranslationService } from "../../services/translation.service";
export type ConfirmationDialogConfig = {
  title: string;
  message: string;
};
export declare class ConfirmationDialog {
  private documentOverflow;
  private cancelButton;
  hostElement: HTMLElement;
  translationService: TranslationService;
  config: ConfirmationDialogConfig;
  /**
   * Event fired when confirmation is rejected and the dialog should be closed.
   */
  internalConfirmationRejectedEvent: EventEmitter;
  /**
   * Event fired when confirmation is rejected and the dialog should be closed.
   */
  internalConfirmationApprovedEvent: EventEmitter;
  /**
   * Handles the Escape key keydown event and closes the dialog.
   * @param ev The keyboard event.
   */
  keydownListener(ev: KeyboardEvent): void;
  private preventLeavingDialog;
  onClose(evt: MouseEvent): void;
  onConfirm(evt: MouseEvent): void;
  componentDidLoad(): void;
  disconnectedCallback(): void;
  render(): any;
}
