import { EventEmitter } from '../../stencil-public-runtime';
import { TranslationService } from '../../services/translation.service';
import { DropdownOption } from '../../models/dropdown-option';
import { InternalDropdownValueSelectedEvent } from '../../models/internal-events/internal-dropdown-value-selected-event';
export declare class Dropdown {
  open: boolean;
  showTooltip: boolean;
  translationService: TranslationService;
  nameLabelKey: string;
  tooltipLabelKey: string;
  items: DropdownOption[];
  iconClass: string;
  valueChanged: EventEmitter<InternalDropdownValueSelectedEvent>;
  /**
   * Handles the Escape key keydown event and closes the dialog.
   * @param ev The keyboard event.
   */
  keydownListener(ev: KeyboardEvent): void;
  /**
   * Handles the mouse click events and closes the menu when target is outside the menu.
   * @param ev The mouse event.
   */
  mouseClickListener(ev: PointerEvent): void;
  render(): any;
  private onSelect;
  private toggleComponent;
  private translate;
  private closeMenu;
}
