import { EventEmitter } from '../../stencil-public-runtime';
import { TranslationService } from '../../services/translation.service';
export declare class OntotextEditableTextField {
  private inputElement;
  /**
   * There is an issue when the component is opened programmatically, for instance, when it is opened from a context menu. In such cases,
   * the handler {@link OntotextEditableTextField#handleClickOutside} checks if the event is outside the component and takes an action.
   * This action is normally executed when the component is open and the user clicks outside the component.
   * This parameter is used to control when the first click event should be skipped.
   */
  private skipFirstClickOutside;
  private editedValue;
  hostElement: HTMLElement;
  /**
   * The value of the text field.
   */
  value: string;
  /**
   * Controls the view mode of component. If true the component will be in Edit mode.
   */
  edit: boolean;
  translationService: TranslationService;
  /**
   * Handler for changing view mode of component. When this happened a componentModeChanged even will be fired.
   *
   * @param edit - the new view mode.
   */
  handleEditModeChange(edit: boolean): void;
  /**
   * The "valueChanged" event is fired when the text field value changes.
   */
  valueChanged: EventEmitter<string>;
  /**
   * The "componentModeChanged" event is fired when the view mode changes.
   */
  componentModeChanged: EventEmitter<boolean>;
  /**
   * Click handler. Saves {@link OntotextEditableTextField#value} if the click is outside component and component is in edit mode.
   */
  handleClickOutside(event: Event): void;
  keydownListener(ev: KeyboardEvent): void;
  /**
   * Initializes the field that holds edited value when component is loaded.
   */
  componentDidLoad(): void;
  /**
   * Sets the input element on focus if element is on edit mode when component is updated.
   */
  componentDidUpdate(): void;
  /**
   * Saves changed value of the text component for eventual future saving.
   */
  private handleValueChanged;
  /**
   * Switches component to edit mode.
   */
  private openEditMode;
  /**
   * Saves the value of text field and emits "valueChanged" event with the new value.
   */
  private save;
  /**
   * Switches the component in preview mode.
   */
  private cancel;
  render(): any;
}
