import { EventEmitter } from '../../stencil-public-runtime';
import { RenderingMode } from '../../models/yasgui-configuration';
import { OntotextYasgui } from '../../models/ontotext-yasgui';
import { ExternalYasguiConfiguration, TabQueryModel } from "../../models/external-yasgui-configuration";
import { SavedQueryConfig, SaveQueryData, UpdateQueryData } from "../../models/saved-query-configuration";
import { OutputEvent } from '../../models/output-events/output-event';
import { InternalDownloadAsEvent } from '../../models/internal-events/internal-download-as-event';
import { InternalCountQueryEvent } from '../../models/internal-events/internal-count-query-event';
import { InternalQueryEvent } from '../../models/internal-events/internal-query-event';
import { InternalNotificationMessageEvent } from '../../models/internal-events/internal-notification-message-event';
import { InternalShowResourceCopyLinkDialogEvent } from '../../models/internal-events/internal-show-resource-copy-link-dialog-event';
import { InternalShowSavedQueriesEvent } from '../../models/internal-events/internal-show-saved-queries-event';
import { InternalQueryExecuted } from '../../models/internal-events/internal-query-executed';
import { InternalCountQueryResponseEvent } from '../../models/internal-events/internal-count-query-response-event';
import { YasqeButtonType } from '../../models/yasqe-button-name';
import { Tab } from '../../models/yasgui/tab';
import { SavedQueryOpened } from '../../models/output-events/saved-query-opened';
import { InternalRequestAbortedEvent } from '../../models/internal-events/internal-request-aborted-event';
import { OngoingRequestsInfo } from '../../models/ongoing-requests-info';
import { YasguiResetFlags } from "../../models/yasgui/yasgui-reset-flags";
/**
 * This is the custom web component which is adapter for the yasgui library. It allows as to
 * configure and extend the library without potentially breaking the component clients.
 *
 * The component have some sane defaults for most of its configurations. So, in practice, it can be
 * used as is by providing just the sparql endpoint config.
 * For other customizations, the default configurations can be overridden by providing an external
 * configuration object compliant with the <code>ExternalYasguiConfiguration</code> interface to the
 * component.
 *
 * There is a configuration watcher which triggers the initialization again after a change is
 * detected.
 *
 * During the component initialization, the provided external configuration is passed down to a
 * configuration builder which use it to override and extend the yasgui library defaults.
 *
 * After the configuration is ready, then a yasgui instance is created with it.
 *
 * After the yasgui instance is ready, then a post initialization phase begins. During the phase the
 * yasgui can be tweaked using the values from the configuration.
 */
export declare class OntotextYasguiWebComponent {
  private readonly translationService;
  private readonly serviceFactory;
  private readonly yasguiConfigurationBuilder;
  private readonly yasguiBuilder;
  private readonly ontotextYasguiService;
  private readonly notificationMessageService;
  private defaultViewMode;
  private tabsListHeight;
  private tabsListResizeObserver;
  private subscriptions;
  /**
   * The instance of our adapter around the actual yasgui instance.
   */
  ontotextYasgui: OntotextYasgui;
  constructor();
  /**
   * The host html element for the yasgui.
   */
  hostElement: HTMLElement;
  /**
   * An input object property containing the yasgui configuration.
   */
  config: ExternalYasguiConfiguration;
  configurationChanged(newConfig: ExternalYasguiConfiguration): void;
  /**
   * An input property containing the chosen translation language.
   */
  language: string;
  languageChanged(newLang: string): void;
  /**
   * A configuration model related with all the saved queries actions.
   */
  savedQueryConfig?: SavedQueryConfig;
  savedQueryConfigChanged(): void;
  /**
   * Event emitted when saved query payload is collected and the query should be saved by the
   * component client.
   */
  createSavedQuery: EventEmitter<SaveQueryData>;
  /**
   * Event emitted when a query payload is updated and the query name is the same as the one being
   * edited. In result the client must perform a query update.
   */
  updateSavedQuery: EventEmitter<SaveQueryData>;
  /**
   * Event emitted when a saved query is loaded into a tab.
   */
  saveQueryOpened: EventEmitter<SavedQueryOpened>;
  /**
   * Event emitted when a saved query should be deleted. In result the client must perform a query
   * delete.
   */
  deleteSavedQuery: EventEmitter<SaveQueryData>;
  /**
   * Event emitted when saved queries is expected to be loaded by the component client and provided
   * back in order to be displayed.
   */
  loadSavedQueries: EventEmitter<boolean>;
  /**
   * Event emitted when saved query share link has to be build by the client.
   */
  shareSavedQuery: EventEmitter<SaveQueryData>;
  /**
   * Event emitted when query share link gets copied in the clipboard.
   */
  queryShareLinkCopied: EventEmitter;
  /**
   * Event emitted when saved query share link has to be build by the client.
   */
  shareQuery: EventEmitter<TabQueryModel>;
  /**
   * Event emitter used to send message to the clients of component.
   */
  output: EventEmitter<OutputEvent>;
  /**
   * A model which is set when query details are populated and the query is going to be saved.
   */
  saveQueryData: SaveQueryData;
  /**
   * A model which is set when an existing saved query is edited and is going to be saved.
   */
  savedQueryData: SaveQueryData;
  /**
   * A query model which is set when a query is set to be deleted.
   */
  deleteQueryData: SaveQueryData;
  /**
   * If the yasgui layout is oriented vertically or not.
   */
  isVerticalOrientation: boolean;
  onOrientationChanged(): void;
  /**
   * Holds the rendering mode currently applied to the yasgui component.
   */
  renderingMode: any;
  /**
   * Flag controlling the visibility of the save query dialog.
   */
  showSaveQueryDialog: boolean;
  /**
   * Flag controlling the visibility of the saved queries list popup.
   */
  showSavedQueriesPopup: boolean;
  showSavedQueriesPopupTarget: HTMLElement;
  showConfirmationDialog: boolean;
  showShareQueryDialog: boolean;
  showCopyResourceLinkDialog: boolean;
  copiedResourceLink: string;
  loaderMessage: string;
  additionalLoaderMessage: string;
  yasqeBtnLabel: string;
  yasguiBtnLabel: string;
  yasrBtnLabel: string;
  /**
   * Changes rendering mode of component.
   *
   * @param newRenderMode - then new render mode of component.
   * @param editorHeight - the height for yasqe.
   */
  changeRenderMode(newRenderMode: RenderingMode, editorHeight?: number): Promise<void>;
  /**
   * Allows the client to set a query in the current opened tab.
   * The cursor position is preserved.
   *
   * @param query The query that should be set in the current focused tab.
   */
  setQuery(query: string): Promise<void>;
  /**
   * Executes the YASQE query from the currently opened tab and switches to the specified <code>renderingMode</code> when the query is executed.
   *
   * @param renderingMode - specifies the new view mode of the component when the query is executed.
   */
  query(renderingMode?: RenderingMode): Promise<any>;
  /**
   * Fetches the query from YASQE editor.
   */
  getQuery(): Promise<string>;
  /**
   * Checks if query is valid.
   */
  isQueryValid(): Promise<boolean>;
  /**
   * Allows the client to init the editor using a query model. When the query and query name are
   * found in any existing opened tab, then it'd be focused. Otherwise a new tab will be created and
   * initialized using the provided query model.
   * @param queryModel The query model.
   */
  openTab(queryModel: TabQueryModel): Promise<Tab>;
  /**
   * Utility method allowing the client to get the mode of the query which is written in the current
   * editor tab.
   * The query mode can be either `query` or `update` regarding the query mode. This method just
   * exposes the similar utility method from the yasqe component.
   *
   * @return A promise which resolves with a string representing the query mode.
   */
  getQueryMode(): Promise<string>;
  /**
   * Utility method allowing the client to get the type of the query which is written in the current
   * editor tab.
   * The query mode can be `INSERT`, `LOAD`, `CLEAR`, `DELETE`, etc. This method just exposes the
   * similar utility method from the yasqe component.
   *
   * @return A promise which resolves with a string representing the query type.
   */
  getQueryType(): Promise<string>;
  /**
   * Fetches the query result and return it as JSON.
   */
  getEmbeddedResultAsJson(): Promise<unknown>;
  /**
   * Fetches the query result and return it as CSV.
   */
  getEmbeddedResultAsCSV(): Promise<unknown>;
  /**
   * Hides the YASQE action button with the name <code>yasqeActionButtonNames</code>.
   *
   * @param yasqeActionButtonNames - the name of the action that needs to be hidden.
   */
  hideYasqeActionButton(yasqeActionButtonNames: YasqeButtonType | YasqeButtonType[]): Promise<void>;
  /**
   * Shows the YASQE action button with the name <code>yasqeActionButtonNames</code>.
   *
   * @param yasqeActionButtonNames - the name of the action that needs to be displayed.
   */
  showYasqeActionButton(yasqeActionButtonNames: YasqeButtonType | YasqeButtonType[]): Promise<void>;
  /**
   * Fetches info about ongoing requests.
   */
  getOngoingRequestsInfo(): Promise<OngoingRequestsInfo>;
  /**
   * Aborts the running query if any.
   */
  abortQuery(): Promise<any>;
  /**
   * Aborts all running requests.
   */
  abortAllRequests(): Promise<any>;
  /**
   * Reinitializes the Yasgui component by resetting the defined flags to those in the configuration.
   * Clears the results of the query.
   * @param resetFlags - object defining the flags for what to reset
   */
  reInitYasgui(resetFlags: YasguiResetFlags): Promise<any>;
  /**
   * Checks whether the query has been modified after the initialization of the YASQE editor.
   */
  isQueryDirty(): Promise<boolean>;
  /**
   * There are rendering problems when the window size is changed. To address this, we added a listener to the window resize event.
   * When the event occurs, we refresh the component to recalculate and resolve the rendering issues.
   */
  onResize(): void;
  onBeforeunloadHandler(): void;
  /**
   * Handler for the event fired when the save query button in the yasqe toolbar is triggered.
   */
  saveQueryHandler(): void;
  /**
   * Handler for the event fired when the query should be saved by the component client.
   */
  createSavedQueryHandler(event: CustomEvent<SaveQueryData>): void;
  /**
   * Handler for the event fired when the query should be saved by the component client.
   */
  updateSavedQueryHandler(event: CustomEvent<UpdateQueryData>): void;
  /**
   * Handler for the event fired when the saveQueryDialog gets closed.
   */
  closeSaveDialogHandler(): void;
  /**
   * Handler for the event fired when the show saved queries button in the yasqe toolbar is triggered.
   */
  showSavedQueriesHandler(event: CustomEvent<InternalShowSavedQueriesEvent>): void;
  /**
   * Handles the event fired when the saved query is selected from the saved queries list. Tries to
   * find a tab with the same name and query inside and opens it. Otherwise opens a new tab with
   * provided parameters. When a saved query is loaded into a tab, emit the 'saveQueryOpened' event with the tab instance.
   */
  savedQuerySelectedHandler(event: CustomEvent<SaveQueryData>): void;
  /**
   * Handler for the event fired when the edit saved query button is triggered.
   */
  editSavedQueryHandler(event: CustomEvent<SaveQueryData>): void;
  /**
   * Handler for the event fired when the delete saved query button is triggered.
   */
  savedQuerySelectedForEditHandler(event: CustomEvent<SaveQueryData>): void;
  /**
   * Handler for confirmation event fired when deletion of saved query is approved.
   */
  deleteSavedQueryHandler(): void;
  /**
   * Handler for the event for closing the saved query delete confirmation dialog.
   */
  closeSavedQueryDeleteConfirmationHandler(): void;
  /**
   * Handler for the event for closing the saved queries popup.
   */
  closeSavedQueriesPopupHandler(): void;
  /**
   * Handler for the event fired when the share saved query button is triggered.
   */
  savedQuerySelectedForShareHandler(event: CustomEvent<SaveQueryData>): void;
  /**
   * Handler for the event fired when the share query button in the editor is triggered.
   */
  shareQueryHandler(): void;
  /**
   * Handler for the internal event fired when a query share link is copied in the clipboard.
   */
  savedQueryShareLinkCopiedHandler(): void;
  /**
   * Handler for the event for closing the share query dialog.
   */
  closeShareQueryDialogHandler(): void;
  /**
   * Handler for the event fired when the copy link dialog is closed without copying the link to the clipboard.
   */
  resourceLinkDialogClosedHandler(): void;
  /**
   * Handler for the event fired when the copy link dialog is closed when the link is copied to the clipboard.
   */
  resourceLinkCopiedHandler(): void;
  /**
   * Handler for the event fired when the copy link dialog is closed when the link is copied to the clipboard.
   */
  showResourceCopyLinkDialogHandler(event: CustomEvent<InternalShowResourceCopyLinkDialogEvent>): void;
  onDownloadAsEventHandler(downloadAsEvent: CustomEvent<InternalDownloadAsEvent>): void;
  notificationMessageHandler(event: CustomEvent<InternalNotificationMessageEvent>): void;
  onQuery(event: CustomEvent<InternalQueryEvent>): void;
  onInternalQueryExecuted(event: CustomEvent<InternalQueryExecuted>): void;
  onCountQuery(event: CustomEvent<InternalCountQueryEvent>): void;
  onCountQueryResponse(event: CustomEvent<InternalCountQueryResponseEvent>): void;
  onQueryAborted(event: CustomEvent<InternalRequestAbortedEvent>): void;
  private resolveOrientationButtonTooltip;
  private changeOrientation;
  private getDefaultSaveQueryData;
  private initSaveQueryData;
  private getSaveQueryData;
  private getSaveQueriesData;
  private getRenderMode;
  private getOrientationMode;
  private shouldShowSaveQueryDialog;
  private isSavedQuerySaved;
  private shouldShowSavedQueriesPopup;
  private getDeleteQueryConfirmationConfig;
  private getShareLinkDialogConfig;
  private getOntotextYasgui;
  private changeRenderingMode;
  private isOntotextYasguiInitialiazed;
  private afterInit;
  registerEventHandlers(): void;
  private updateYasrTopMargin;
  private registerTabsListResizeObserver;
  private unregisterTabsListResizeObserver;
  private destroy;
  private initComponentTranslationHandlers;
  private init;
  componentWillLoad(): void;
  componentDidLoad(): void;
  disconnectedCallback(): void;
  render(): any;
}
