import { EventEmitter } from '../../stencil-public-runtime';
import { ServiceFactory } from '../../services/service-factory';
import { SaveQueryData, UpdateQueryData } from "../../models/saved-query-configuration";
export declare class SaveQueryDialog {
  private translationService;
  private documentOverflow;
  private cancelButton;
  hostElement: HTMLElement;
  serviceFactory: ServiceFactory;
  /**
   * Input holding the saved query data if available. This data is used to initialize the form.
   */
  data: SaveQueryData;
  queryName: string;
  query: string;
  isPublic: boolean;
  isNew: boolean;
  isSaveAllowed: boolean;
  /**
   * Event fired when the dialog is closed by triggering one of the close controls, e.g. close or
   * cancel button.
   */
  internalSaveQueryDialogClosedEvent: EventEmitter;
  /**
   * Event fired when the create button in the dialog is triggered. The event payload holds the new
   * saved query data.
   */
  internalSaveQueryEvent: EventEmitter<SaveQueryData>;
  /**
   * Event fired when the create button in the dialog is triggered and the query name is the same as
   * the one that was initially provided a.k.a. the query is updated. The event payload holds the
   * updated query data.
   */
  internalUpdateQueryEvent: EventEmitter<UpdateQueryData>;
  /**
   * Handles the Escape key keydown event and closes the dialog.
   * @param ev The keyboard event.
   */
  keydownListener(ev: KeyboardEvent): void;
  componentWillLoad(): void;
  componentDidLoad(): void;
  disconnectedCallback(): void;
  onClose(evt: MouseEvent): void;
  onCreate(evt: MouseEvent): void;
  handleQueryNameChange(event: any): void;
  handleQueryChange(event: any): void;
  handleIsPublicChange(event: any): void;
  private preventLeavingDialog;
  private resolveIsSaveAllowed;
  private getErrorMessages;
  private hasMissingQueryName;
  private hasMissingQuery;
  private hasMissingFields;
  private showErrorMessage;
  render(): any;
}
