import { EventEmitter } from '../../stencil-public-runtime';
import { SavedQueriesData, SaveQueryData } from "../../models/saved-query-configuration";
import { ServiceFactory } from "../../services/service-factory";
export declare class SavedQueriesPopup {
  private translationService;
  hostElement: HTMLElement;
  config: SavedQueriesData;
  serviceFactory: ServiceFactory;
  /**
   * Event fired when a saved query is selected from the list.
   */
  internalSaveQuerySelectedEvent: EventEmitter<SaveQueryData>;
  /**
   * Event fired when the edit saved query button is triggered.
   */
  internalEditSavedQueryEvent: EventEmitter<SaveQueryData>;
  /**
   * Event fired when the delete saved query button is triggered.
   */
  internalSavedQuerySelectedForDeleteEvent: EventEmitter<SaveQueryData>;
  /**
   * Event fired when the share saved query button is triggered.
   */
  internalSavedQuerySelectedForShareEvent: EventEmitter<SaveQueryData>;
  /**
   * Event fired when the saved queries popup should be closed.
   */
  internalCloseSavedQueriesPopupEvent: EventEmitter;
  onWindowResize(event: PointerEvent): void;
  /**
   * Handles the Escape key keydown event and closes the dialog.
   * @param ev The keyboard event.
   */
  keydownListener(ev: KeyboardEvent): void;
  onSelect(evt: any, selectedQuery: SaveQueryData): void;
  componentWillLoad(): void;
  componentDidRender(): void;
  onEdit(evt: MouseEvent, selectedQuery: SaveQueryData): void;
  onDelete(evt: MouseEvent, selectedQuery: SaveQueryData): void;
  onShare(evt: MouseEvent, selectedQuery: SaveQueryData): void;
  private setPopupPosition;
  render(): any;
}
