import { EventEmitter } from '../../stencil-public-runtime';
import { ServiceFactory } from "../../services/service-factory";
import { CopyLinkObserver } from '../copy-link-dialog/copy-link-dialog';
export type ShareQueryDialogConfig = {
  shareQueryLink: string;
};
export declare class ShareQueryDialog implements CopyLinkObserver {
  config: ShareQueryDialogConfig;
  serviceFactory: ServiceFactory;
  /**
   * Event fired when the dialog is closed by triggering one of the close controls, e.g. close or
   * cancel button as well as clicking outside of the dialog.
   */
  internalShareQueryDialogClosedEvent: EventEmitter;
  /**
   * Internal event fired when saved query share link is copied in the clipboard.
   */
  internalQueryShareLinkCopiedEvent: EventEmitter;
  onDialogClosed(): void;
  onLinkCopied(): void;
  render(): any;
}
