import { InternalEvent } from './internal-event';
import { InternalEventType } from './internal-event-types';
import { OutputEventType } from '../output-events/output-event-types';
export type NotificationMessageType = (typeof MessageType)[keyof typeof MessageType];
export declare const MessageType: {
  SUCCESS: string;
  ERROR: string;
  WARNING: string;
  INFO: string;
};
export type NotificationMessageCode = (typeof MessageCode)[keyof typeof MessageCode];
export declare const MessageCode: {
  RESOURCE_LINK_COPIED_SUCCESSFULLY: string;
  QUERY_IS_RUNNING: string;
  EXPLAIN_NOT_ALLOWED: string;
  EXPLAIN_EXIT_FULLSCREEN: string;
};
export declare class InternalNotificationMessageEvent implements InternalEvent {
  TYPE: InternalEventType;
  OUTPUT_TYPE: OutputEventType;
  payload: {
    code: NotificationMessageCode;
    messageType: NotificationMessageType;
    message: string;
  };
  constructor(code: NotificationMessageCode, messageType: NotificationMessageType, message: string);
}
