import { Yasqe } from './yasgui/yasqe';
import { YasguiConfiguration } from './yasgui-configuration';
import { TabQueryModel } from "./external-yasgui-configuration";
import { Yasgui } from './yasgui/yasgui';
import { Tab } from './yasgui/tab';
import { OngoingRequestsInfo } from './ongoing-requests-info';
import { YasguiResetFlags } from "./yasgui/yasgui-reset-flags";
/**
 * An adapter around the actual yasgui instance.
 */
export declare class OntotextYasgui {
  /**
   * The yasgui instance.
   */
  private yasgui;
  /**
   * The yasgui configuration.
   */
  private config;
  constructor(yasgui: Yasgui, config: YasguiConfiguration);
  refresh(): void;
  /**
   * Initializes the adapter.
   */
  private init;
  registerYasqeEventListener(eventName: any, callback: any): void;
  getYasqe(): Yasqe;
  leaveFullScreen(): void;
  /**
   * Sets a query value in the editor by preserving the cursor position.
   * @param query The query value to be set.
   */
  setQuery(query: string): void;
  query(): Promise<any>;
  getOngoingRequestsInfo(): OngoingRequestsInfo;
  abortQuery(): void;
  abortAllRequests(): void;
  /**
   * Reinitializes the Yasgui component by resetting the defined flags to those in the configuration.
   * Clears the results of the query.
   * @param resetFlags - the flags object used when resetting the Yasgui component
   */
  reInitYasgui(resetFlags: YasguiResetFlags): void;
  getQuery(): string;
  saveQuery(): void;
  isQueryDirty(): boolean;
  isQueryValid(): boolean;
  getQueryMode(): string;
  getQueryType(): string;
  getEmbeddedResultAsJson(): string;
  getEmbeddedResultAsCSV(): string;
  getConfig(): YasguiConfiguration;
  setConfig(yasguiConfiguration: YasguiConfiguration): void;
  getInstance(): Yasgui;
  setInstance(yasgui: Yasgui): void;
  getTab(tabId?: string): Tab;
  getTabId(): string;
  getTabName(): string;
  getTabQuery(): string;
  openTab(queryModel: TabQueryModel): Tab;
  createNewTab(queryName: string, query: string): Tab;
  /**
   * Searches the local store for the given tab ID and returns the height for the yasqe editor. If no height can be found,
   * the default 300 is returned.
   * @param tabId
   */
  getEditorHeight(tabId: string): number;
  destroy(): void;
}
