/**
 * A model for all the configurations related with the saved query functionality.
 * This is supposed to be passed down by the component client in order to communicate that there is
 * a query saving problem, or that the saved queries are loaded, etc.
 */
export interface SavedQueryConfig {
  /**
   * Configuration which should be set by the client when saved queries are
   * loaded. Once queries response is set, the saved queries dialog pops up.
   */
  savedQueries?: SavedQueryInput[];
  /**
   * Configurations which should be set when query saving request has
   * failed for some reason. This is taken into account when the visibility
   * of the save query dialog is resolved and what messages are rendered
   * inside it.
   */
  saveSuccess?: boolean;
  /**
   * Any error message which can appear during the query saving.
   */
  errorMessage?: string[];
  /**
   * A link for sharing particular query: a saved query or just current tab query.
   */
  shareQueryLink?: string;
}
export interface SavedQueryInput {
  queryName: string;
  query: string;
  isPublic: boolean;
  owner: string;
}
export declare class SaveQueryData {
  queryName: string;
  query: string;
  isPublic: boolean;
  isNew?: boolean;
  owner?: string;
  messages?: string[];
  constructor(queryName: string, query: string, isPublic: boolean, isNew?: boolean, owner?: string, messages?: string[]);
}
export declare class UpdateQueryData extends SaveQueryData {
}
export declare class DeleteQueryData extends SaveQueryData {
}
export declare class SavedQueriesData {
  savedQueriesList: SaveQueryData[];
  popupTarget: HTMLElement;
  constructor(savedQueriesList: SaveQueryData[], popupTarget: HTMLElement);
}
