/// <reference types="node" />
import { default as Yasqe, Token, Hint, Position, Config } from "../";
import { EventEmitter } from "events";
export interface CompleterConfig {
  onInitialize?: (this: CompleterConfig, yasqe: Yasqe) => void;
  isValidCompletionPosition: (yasqe: Yasqe) => boolean;
  get: (yasqe: Yasqe, token?: AutocompletionToken) => Promise<string[]> | string[];
  preProcessToken?: (yasqe: Yasqe, token: Token) => AutocompletionToken;
  postProcessSuggestion?: (yasqe: Yasqe, token: AutocompletionToken, suggestedString: string) => string;
  postprocessHints?: (yasqe: Yasqe, hints: Hint[]) => Hint[];
  bulk: boolean;
  autoShow?: boolean;
  persistenceId?: Config["persistenceId"];
  name: string;
}
export interface AutocompletionToken extends Token {
  autocompletionString?: string;
  tokenPrefix?: string;
  tokenPrefixUri?: string;
  from?: Partial<Position>;
  to?: Partial<Position>;
}
export declare class Completer extends EventEmitter {
  protected yasqe: Yasqe;
  private trie?;
  private config;
  constructor(yasqe: Yasqe, config: CompleterConfig);
  private getStorageId;
  /**
   * Store bulk completion in local storage, and populates the trie
   */
  private storeBulkCompletions;
  /**
   * Get completion list from `get` function
   */
  getCompletions(token?: AutocompletionToken): Promise<string[]>;
  /**
   * Populates completions. Pre-fetches those if bulk is set to true
   */
  initialize(): Promise<void>;
  private isValidPosition;
  /**
   * Builds a hint object expected by the underlying codemirror.
   * @param autocompletionToken
   * @param suggested This in the original api is expected to be string, but here we changed it to
   * accept also an object in format <code>{type: string, value: string, description: string}</code>.
   * This is the format in which we load the suggestions. Some of the autocompleters though are
   * using strings, so we shall support both.
   */
  private getHint;
  private getHints;
  autocomplete(fromAutoShow: boolean): boolean;
}
/**
 * Converts rdf:type to http://.../type and converts <http://...> to http://...
 * Stores additional info such as the used namespace and prefix in the token object
 */
export declare function preprocessIriForCompletion(yasqe: Yasqe, token: AutocompletionToken): AutocompletionToken;
export declare function postprocessIriCompletion(yasqe: Yasqe, token: AutocompletionToken, suggestedString: string): string;
export declare const fetchFromLov: (yasqe: Yasqe, type: "class" | "property", token?: AutocompletionToken) => Promise<string[]>;
export declare var completers: CompleterConfig[];
