/**
 * The default options of YASQE (check the CodeMirror documentation for even
 * more options, such as disabling line numbers, or changing keyboard shortcut
 * keys). Either change the default options by setting Yasqe.defaults, or by
 * passing your own options as second argument to the YASQE constructor
 */
import { default as Yasqe, PlainRequestConfig } from "./";
import { EventService, NotificationMessageService, TranslationService } from "@triply/yasgui-utils";
export default function get(): {
  requestConfig: PlainRequestConfig;
  value?: any;
  autofocus?: boolean;
  readOnly?: any;
  spellcheck?: boolean;
  tabindex?: number;
  autocapitalize?: boolean;
  autocorrect?: boolean;
  mode: string;
  prefixes: string[];
  theme?: string;
  indentUnit?: number;
  smartIndent?: boolean;
  tabSize?: number;
  indentWithTabs?: boolean;
  electricChars?: boolean;
  rtlMoveVisually?: boolean;
  keyMap?: string;
  extraKeys?: string | import("codemirror").KeyMap;
  lineWrapping?: boolean;
  lineNumbers?: boolean;
  firstLineNumber?: number;
  lineNumberFormatter?: (line: number) => string;
  gutters?: string[];
  foldGutter: any;
  fixedGutter?: boolean;
  scrollbarStyle?: string;
  coverGutterNextToScrollbar?: boolean;
  inputStyle?: import("codemirror").InputStyle;
  screenReaderLabel?: string;
  showCursorWhenSelecting?: boolean;
  lineWiseCopyCut?: boolean;
  pasteLinesPerSelection?: boolean;
  selectionsMayTouch?: boolean;
  undoDepth?: number;
  historyEventDelay?: number;
  dragDrop?: boolean;
  allowDropFileTypes?: string[];
  onDragEvent?: (instance: import("codemirror").Editor, event: DragEvent) => boolean;
  onKeyEvent?: (instance: import("codemirror").Editor, event: KeyboardEvent) => boolean;
  cursorBlinkRate?: number;
  cursorScrollMargin?: number;
  cursorHeight?: number;
  resetSelectionOnContextMenu?: boolean;
  workTime?: number;
  workDelay?: number;
  pollInterval?: number;
  flattenSpans?: boolean;
  addModeClass?: boolean;
  maxHighlightLength?: number;
  viewportMargin?: number;
  lint?: boolean | import("codemirror").LintStateOptions | import("codemirror").Linter | import("codemirror").AsyncLinter;
  persistenceId: string | ((yasqe: Yasqe) => string);
  collapsePrefixesOnLoad: boolean;
  syntaxErrorCheck: boolean;
  createShareableLink: (yasqe: Yasqe) => string;
  createShortLink: (yasqe: Yasqe, longLink: string) => Promise<string>;
  consumeShareLink: (yasqe: Yasqe) => void;
  persistencyExpire: number;
  showQueryButton: boolean;
  pluginButtons: (yasqe: Yasqe) => HTMLElement | HTMLElement[];
  highlightSelectionMatches: {
    showToken?: RegExp;
    annotateScrollbar?: boolean;
  };
  tabMode: string;
  matchBrackets: boolean;
  autoCloseBrackets: boolean;
  autocompleters: string[];
  hintConfig: Partial<import("./").HintConfig>;
  resizeable: boolean;
  editorHeight: string;
  queryingDisabled: string;
  prefixCcApi: string;
  translationService: TranslationService;
  notificationMessageService: NotificationMessageService;
  eventService: EventService;
  infer?: boolean;
  sameAs?: boolean;
  pageSize?: number;
  pageNumber?: number;
  explainPlanQueryType?: import("@triply/yasgui-utils").EXPLAIN_PLAN_TYPE;
  paginationOn?: boolean;
  keyboardShortcutDescriptions?: [];
  isVirtualRepository: boolean;
  beforeUpdateQuery: (query: string, tabId: string) => Promise<import("./").CustomResultMessage>;
  tabId: string;
  getRepositoryStatementsCount: () => Promise<number>;
  onQueryAborted?: (req: import("superagent").SuperAgentRequest) => Promise<void>;
};
