import { EventService, EXPLAIN_PLAN_TYPE, NotificationMessageService, TranslationParameter, TranslationService } from "@triply/yasgui-utils";
import * as superagent from "superagent";
import { Prefixes } from "./prefixUtils";
import * as sparql11Mode from "../grammar/tokenizer";
import { Storage as YStorage } from "@triply/yasgui-utils";
import * as queryString from "query-string";
import * as Sparql from "./sparql";
import * as Autocompleter from "./autocompleters";
import CodeMirror from "./CodeMirror";
export interface Yasqe {
  on(eventName: "query", handler: (instance: Yasqe, req: superagent.SuperAgentRequest) => void): void;
  off(eventName: "query", handler: (instance: Yasqe, req: superagent.SuperAgentRequest) => void): void;
  on(eventName: "countQuery", handler: (instance: Yasqe, req: superagent.SuperAgentRequest) => void): void;
  off(eventName: "countQuery", handler: (instance: Yasqe, req: superagent.SuperAgentRequest) => void): void;
  on(eventName: "countQueryFinished", handler: (instance: Yasqe) => void): void;
  off(eventName: "countQueryFinished", handler: (instance: Yasqe) => void): void;
  on(eventName: "queryAbort", handler: (instance: Yasqe, req: superagent.SuperAgentRequest) => void): void;
  off(eventName: "queryAbort", handler: (instance: Yasqe, req: superagent.SuperAgentRequest) => void): void;
  on(eventName: "queryResponse", handler: (instance: Yasqe, req: superagent.SuperAgentRequest, duration: number, queryStartedTime: number) => void): void;
  off(eventName: "queryResponse", handler: (instance: Yasqe, req: superagent.SuperAgentRequest, duration: number, queryStartedTime: number) => void): void;
  on(event: "totalElementsChanged", handler: (instance: Yasqe, totalElements: number) => void): void;
  off(event: "totalElementsChanged", handler: (instance: Yasqe, totalElements: number) => void): void;
  on(event: "countAffectedRepositoryStatementsChanged", handler: (instance: Yasqe, totalElements: number) => void): void;
  off(event: "countAffectedRepositoryStatementsChanged", handler: (instance: Yasqe, totalElements: number) => void): void;
  on(event: "countAffectedRepositoryStatementsPersisted", handler: (instance: Yasqe) => void): void;
  off(event: "countAffectedRepositoryStatementsPersisted", handler: (instance: Yasqe) => void): void;
  showHint: (conf: HintConfig) => void;
  on(eventName: "error", handler: (instance: Yasqe) => void): void;
  off(eventName: "error", handler: (instance: Yasqe) => void): void;
  on(eventName: "blur", handler: (instance: Yasqe) => void): void;
  off(eventName: "blur", handler: (instance: Yasqe) => void): void;
  on(eventName: "queryResults", handler: (instance: Yasqe, results: any, duration: number) => void): void;
  off(eventName: "queryResults", handler: (instance: Yasqe, results: any, duration: number) => void): void;
  on(eventName: "autocompletionShown", handler: (instance: Yasqe, widget: any) => void): void;
  off(eventName: "autocompletionShown", handler: (instance: Yasqe, widget: any) => void): void;
  on(eventName: "autocompletionClose", handler: (instance: Yasqe) => void): void;
  off(eventName: "autocompletionClose", handler: (instance: Yasqe) => void): void;
  on(eventName: "resize", handler: (instance: Yasqe, newSize: string) => void): void;
  off(eventName: "resize", handler: (instance: Yasqe, newSize: string) => void): void;
  on(eventName: string, handler: () => void): void;
  on(eventName: "openNewTab", handler: () => void): void;
  off(eventName: "openNewTab", handler: () => void): void;
  on(eventName: "openNextTab", handler: () => void): void;
  off(eventName: "openNextTab", handler: () => void): void;
  on(eventName: "openPreviousTab", handler: () => void): void;
  off(eventName: "openPreviousTab", handler: () => void): void;
  on(eventName: "closeOtherTabs", handler: () => void): void;
  off(eventName: "closeOtherTabs", handler: () => void): void;
  on(eventName: "queryStatus", handler: (instance: Yasqe, data: any) => void): void;
  off(eventName: "queryStatus", handler: () => void): void;
}
export declare class Yasqe extends CodeMirror {
  private static storageNamespace;
  autocompleters: {
    [name: string]: Autocompleter.Completer | undefined;
  };
  private prevQueryValid;
  queryValid: boolean;
  lastQueryDuration: number | undefined;
  private req;
  private countReq;
  private queryStatus;
  private queryBtn;
  private resizeWrapper?;
  rootEl: HTMLDivElement;
  storage: YStorage;
  config: Config;
  persistentConfig: PersistentConfig | undefined;
  superagent: superagent.SuperAgentStatic;
  private keyboardShortcutsButton;
  private abortQueryButton;
  private showAbortQueryButton;
  private isQueryAborted;
  private infer?;
  private sameAs?;
  private pageSize?;
  private pageNumber?;
  private explainPlanQueryType?;
  readonly translationService: TranslationService;
  readonly notificationMessageService: NotificationMessageService;
  readonly eventService: EventService;
  private readonly isVirtualRepository;
  private readonly tabId;
  private subscriptions;
  constructor(parent: HTMLElement, conf?: PartialConfig);
  private handleHashChange;
  private handleChange;
  private handleBlur;
  private handleChanges;
  private handleCursorActivity;
  update(): void;
  toggleFullScreen(): void;
  enterFullScreen(): void;
  leaveFullScreen(): void;
  private handleQuery;
  private handleCountQuery;
  private handleCountQueryFinished;
  private handleQueryResponse;
  private handleQueryAbort;
  setInfer(infer: boolean): void;
  getInfer(): boolean | undefined;
  setSameAs(sameAs: boolean): void;
  getSameAs(): boolean | undefined;
  setPageNumber(pageNumber: number): void;
  getPageNumber(): number | undefined;
  setPageSize(pageSize: number): void;
  getPageSize(): number | undefined;
  setExplainPlanQueryType(explainType?: EXPLAIN_PLAN_TYPE): void;
  getExplainPlanQueryType(): EXPLAIN_PLAN_TYPE | undefined;
  isExplainPlanQuery(): boolean;
  isQueryRunning(): boolean;
  getTabId(): string;
  private registerEventListeners;
  private unregisterEventListeners;
  /**
   * Generic IDE functions
   */
  emit(event: string, ...data: any[]): void;
  getStorageId(getter?: Config["persistenceId"]): string | undefined;
  private updateButtonsLabels;
  private drawButtons;
  private drawResizer;
  private drawKeyboardShortcutsButton;
  updateKeyboardShortcuts(): void;
  private drawAbortQueryButton;
  private queryStateChanged;
  private updateAbortQueryButton;
  private updateAbortQueryLabels;
  private initDrag;
  private calculateDragOffset;
  private doDrag;
  private stopDrag;
  duplicateLine(): void;
  private updateQueryButton;
  handleLocalStorageQuotaFull(_e: any): void;
  saveQuery(): void;
  /**
   * Get SPARQL query props
   */
  getQueryType(): "DELETE" | "SELECT" | "CONSTRUCT" | "ASK" | "DESCRIBE" | "INSERT" | "LOAD" | "CLEAR" | "CREATE" | "DROP" | "COPY" | "MOVE" | "ADD";
  getQueryMode(): "update" | "query";
  getVariablesFromQuery(): string[];
  /**
   * Sparql-related tasks
   */
  private autoformatSelection;
  static autoformatString(text: string): string;
  commentLines(): void;
  autoformat(): void;
  getQueryWithValues(values: string | {
    [varName: string]: string;
  } | Array<{
    [varName: string]: string;
  }>): string;
  getValueWithoutComments(): string;
  setCheckSyntaxErrors(isEnabled: boolean): void;
  checkSyntax(): void;
  /**
   * Token management
   */
  getCompleteToken(token?: Token, cur?: Position): Token;
  getPreviousNonWsToken(line: number, token: Token): Token;
  getNextNonWsToken(lineNumber: number, charNumber?: number): Token | undefined;
  /**
   * Notification management
   */
  private notificationEls;
  /**
   * Shows notification
   * @param key reference to the notification
   * @param messageLabelKey the message label key to display
   */
  showNotification(key: string, messageLabelKey: string): void;
  /**
   * Hides notification
   * @param key the identifier of the notification to hide
   */
  hideNotification(key: string): void;
  /**
   * Autocompleter management
   */
  enableCompleter(name: string): Promise<void>;
  disableCompleter(name: string): void;
  autocomplete(fromAutoShow?: boolean): void;
  /**
   * Prefix management
   */
  collapsePrefixes(collapse?: boolean): void;
  getPrefixesFromQuery(): Prefixes;
  addPrefixes(prefixes: string | Prefixes): void;
  removePrefixes(prefixes: Prefixes): void;
  updateWidget(): void;
  /**
   * Querying
   */
  query(config?: Sparql.YasqeAjaxConfig, explainType?: EXPLAIN_PLAN_TYPE | undefined): Promise<any>;
  emitEvent(type: string, payload?: any): void;
  emitEventAsync(type: string, payload?: any): void;
  isSelectQuery(): boolean;
  isConstructQuery(): boolean;
  isUpdateQuery(): boolean;
  isDescribeQuery(): boolean;
  isAskQuery(): boolean;
  getUrlParams(): queryString.ParsedQuery<string>;
  configToQueryParams(): queryString.ParsedQuery;
  queryParamsToConfig(params: queryString.ParsedQuery): void;
  getAsCurlString(config?: Sparql.YasqeAjaxConfig): string;
  abortQuery(): void;
  abortCountRequests(): void;
  hasOngoingRequest(): boolean;
  expandEditor(): void;
  destroy(): void;
  /**
   * Statics
   */
  static Sparql: typeof Sparql;
  static runMode: any;
  static clearStorage(): void;
  static Autocompleters: {
    [name: string]: Autocompleter.CompleterConfig;
  };
  static registerAutocompleter(value: Autocompleter.CompleterConfig, enable?: boolean): void;
  static defaults: {
    requestConfig: PlainRequestConfig;
    value?: any;
    autofocus?: boolean;
    readOnly?: any;
    spellcheck?: boolean;
    tabindex?: number;
    autocapitalize?: boolean;
    autocorrect?: boolean;
    mode: string;
    prefixes: string[];
    theme?: string;
    indentUnit?: number;
    smartIndent?: boolean;
    tabSize?: number;
    indentWithTabs?: boolean;
    electricChars?: boolean;
    rtlMoveVisually?: boolean;
    keyMap?: string;
    extraKeys?: string | import("codemirror").KeyMap;
    lineWrapping?: boolean;
    lineNumbers?: boolean;
    firstLineNumber?: number;
    lineNumberFormatter?: (line: number) => string;
    gutters?: string[];
    foldGutter: any;
    fixedGutter?: boolean;
    scrollbarStyle?: string;
    coverGutterNextToScrollbar?: boolean;
    inputStyle?: import("codemirror").InputStyle;
    screenReaderLabel?: string;
    showCursorWhenSelecting?: boolean;
    lineWiseCopyCut?: boolean;
    pasteLinesPerSelection?: boolean;
    selectionsMayTouch?: boolean;
    undoDepth?: number;
    historyEventDelay?: number;
    dragDrop?: boolean;
    allowDropFileTypes?: string[];
    onDragEvent?: (instance: import("codemirror").Editor, event: DragEvent) => boolean;
    onKeyEvent?: (instance: import("codemirror").Editor, event: KeyboardEvent) => boolean;
    cursorBlinkRate?: number;
    cursorScrollMargin?: number;
    cursorHeight?: number;
    resetSelectionOnContextMenu?: boolean;
    workTime?: number;
    workDelay?: number;
    pollInterval?: number;
    flattenSpans?: boolean;
    addModeClass?: boolean;
    maxHighlightLength?: number;
    viewportMargin?: number;
    lint?: boolean | import("codemirror").LintStateOptions | import("codemirror").Linter | import("codemirror").AsyncLinter;
    persistenceId: string | ((yasqe: Yasqe) => string);
    collapsePrefixesOnLoad: boolean;
    syntaxErrorCheck: boolean;
    createShareableLink: (yasqe: Yasqe) => string;
    createShortLink: (yasqe: Yasqe, longLink: string) => Promise<string>;
    consumeShareLink: (yasqe: Yasqe) => void;
    persistencyExpire: number;
    showQueryButton: boolean;
    pluginButtons: (yasqe: Yasqe) => HTMLElement | HTMLElement[];
    highlightSelectionMatches: {
      showToken?: RegExp;
      annotateScrollbar?: boolean;
    };
    tabMode: string;
    matchBrackets: boolean;
    autoCloseBrackets: boolean;
    autocompleters: string[];
    hintConfig: Partial<HintConfig>;
    resizeable: boolean;
    editorHeight: string;
    queryingDisabled: string;
    prefixCcApi: string;
    translationService: TranslationService;
    notificationMessageService: NotificationMessageService;
    eventService: EventService;
    infer?: boolean;
    sameAs?: boolean;
    pageSize?: number;
    pageNumber?: number;
    explainPlanQueryType?: EXPLAIN_PLAN_TYPE;
    paginationOn?: boolean;
    keyboardShortcutDescriptions?: [];
    isVirtualRepository: boolean;
    beforeUpdateQuery: (query: string, tabId: string) => Promise<CustomResultMessage>;
    tabId: string;
    getRepositoryStatementsCount: () => Promise<number>;
    onQueryAborted?: (req: superagent.SuperAgentRequest) => Promise<void>;
  };
  static forkAutocompleter(fromCompleter: string, newCompleter: {
    name: string;
  } & Partial<Autocompleter.CompleterConfig>, enable?: boolean): void;
}
export type TokenizerState = sparql11Mode.State;
export type Position = CodeMirror.Position;
export type Token = CodeMirror.Token;
export interface HintList {
  list: Hint[];
  from: Position;
  to: Position;
}
export interface Hint {
  text: string;
  displayText?: string;
  className?: string;
  render?: (el: HTMLElement, self: Hint, data: any) => void;
  from?: Position;
  to?: Position;
}
export type HintFn = {
  async?: boolean;
} & (() => Promise<HintList> | HintList);
export interface HintConfig {
  completeOnSingleClick?: boolean;
  container?: HTMLElement;
  closeCharacters?: RegExp;
  completeSingle?: boolean;
  hint: HintFn;
  alignWithWord?: boolean;
  closeOnUnfocus?: boolean;
  customKeys?: any;
  extraKeys?: {
    [key: string]: (yasqe: Yasqe, event: {
      close: () => void;
      data: {
        from: Position;
        to: Position;
        list: Hint[];
      };
      length: number;
      menuSize: () => void;
      moveFocus: (movement: number) => void;
      pick: () => void;
      setFocus: (index: number) => void;
    }) => void;
  };
}
export interface RequestConfig<Y> {
  queryArgument: string | ((yasqe: Y) => string) | undefined;
  endpoint: string | ((yasqe: Y) => string);
  method: "POST" | "GET" | ((yasqe: Y) => "POST" | "GET");
  acceptHeaderGraph: string | ((yasqe: Y) => string);
  acceptHeaderSelect: string | ((yasqe: Y) => string);
  acceptHeaderUpdate: string | ((yasqe: Y) => string);
  namedGraphs: string[] | ((yasqe: Y) => string[]);
  defaultGraphs: string[] | ((yasqe: Y) => []);
  args: Array<{
    name: string;
    value: string;
  }> | ((yasqe: Y) => Array<{
    name: string;
    value: string;
  }>);
  headers: {
    [key: string]: string;
  } | ((yasqe: Y) => {
    [key: string]: string;
  });
  withCredentials: boolean | ((yasqe: Y) => boolean);
  adjustQueryBeforeRequest: ((yasqe: Y) => string) | false;
}
export type PlainRequestConfig = {
  [K in keyof RequestConfig<any>]: Exclude<RequestConfig<any>[K], Function>;
};
export type PartialConfig = {
  [P in keyof Config]?: Config[P] extends object ? Partial<Config[P]> : Config[P];
};
export interface Config extends Partial<CodeMirror.EditorConfiguration> {
  mode: string;
  collapsePrefixesOnLoad: boolean;
  syntaxErrorCheck: boolean;
  /**
   * Show a button with which users can create a link to this query. Set this value to null to disable this functionality.
   * By default, this feature is enabled, and the only the query value is appended to the link.
   * ps. This function should return an object which is parseable by jQuery.param (http://api.jquery.com/jQuery.param/)
   */
  createShareableLink: (yasqe: Yasqe) => string;
  createShortLink: ((yasqe: Yasqe, longLink: string) => Promise<string>) | undefined;
  consumeShareLink: ((yasqe: Yasqe) => void) | undefined | null;
  /**
   * Change persistency settings for the YASQE query value. Setting the values
   * to null, will disable persistancy: nothing is stored between browser
   * sessions Setting the values to a string (or a function which returns a
   * string), will store the query in localstorage using the specified string.
   * By default, the ID is dynamically generated using the closest dom ID, to avoid collissions when using multiple YASQE items on one
   * page
   */
  persistenceId: ((yasqe: Yasqe) => string) | string | undefined | null;
  persistencyExpire: number;
  showQueryButton: boolean;
  requestConfig: RequestConfig<Yasqe> | ((yasqe: Yasqe) => RequestConfig<Yasqe>);
  pluginButtons: ((yasqe: Yasqe) => HTMLElement[] | HTMLElement) | undefined;
  highlightSelectionMatches: {
    showToken?: RegExp;
    annotateScrollbar?: boolean;
  };
  tabMode: string;
  foldGutter: any;
  matchBrackets: boolean;
  autoCloseBrackets: boolean;
  autocompleters: string[];
  hintConfig: Partial<HintConfig>;
  resizeable: boolean;
  editorHeight: string;
  queryingDisabled: string | undefined;
  prefixCcApi: string;
  prefixes: string[];
  translationService: TranslationService;
  notificationMessageService: NotificationMessageService;
  eventService: EventService;
  infer?: boolean;
  sameAs?: boolean;
  pageSize?: number;
  pageNumber?: number;
  explainPlanQueryType?: EXPLAIN_PLAN_TYPE;
  paginationOn?: boolean;
  keyboardShortcutDescriptions?: [];
  isVirtualRepository: boolean;
  beforeUpdateQuery: (query: string, tabId: string) => Promise<CustomResultMessage>;
  tabId: string;
  getRepositoryStatementsCount: () => Promise<number>;
  onQueryAborted?: (req: superagent.SuperAgentRequest | undefined) => Promise<void>;
}
export interface CustomResultMessage {
  status: QueryResponseStatus;
  message?: string;
  messageLabelKey?: string;
  parameters?: TranslationParameter[];
}
export declare enum QueryResponseStatus {
  ERROR = "error",
  SUCCESS = "success"
}
export interface PersistentConfig {
  query: string;
  editorHeight: string;
  pageSize?: number;
  pageNumber?: number;
}
export default Yasqe;
