import { default as Yasqe, Token, Position } from "./";
/**
 * When typing a query, this query is sometimes syntactically invalid, causing
 * the current tokens to be incorrect This causes problem for autocompletion.
 * http://bla might result in two tokens: http:// and bla. We'll want to combine
 * these
 */
export declare function getCompleteToken(yasqe: Yasqe, token?: Token, cur?: Position): Token;
export declare function getPreviousNonWsToken(yasqe: Yasqe, line: number, token: Token): Token;
export declare function getNextNonWsToken(yasqe: Yasqe, lineNumber: number, charNumber?: number): Token | undefined;
